﻿---
title: elasticsearch-certutil
description: The elasticsearch-certutil command simplifies the creation of certificates for use with Transport Layer Security (TLS) in the Elastic Stack. You can specify...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-certutil
The `elasticsearch-certutil` command simplifies the creation of certificates for use with Transport Layer Security (TLS) in the Elastic Stack.

## Synopsis

```shell
bin/elasticsearch-certutil
(
(ca [--ca-dn <name>] [--keyusage <key_usages>] [--days <n>] [--pem])

| (cert ([--ca <file_path>] | [--ca-cert <file_path> --ca-key <file_path>])
[--ca-dn <name>] [--ca-pass <password>] [--days <n>]
[--dns <domain_name>] [--in <input_file>] [--ip <ip_addresses>]
[--multiple] [--name <file_name>] [--pem] [--self-signed])

| (csr [--dns <domain_name>] [--in <input_file>] [--ip <ip_addresses>]
[--name <file_name>])

[-E <KeyValuePair>] [--keysize <bits>] [--out <file_path>]
[--pass <password>]
)

| http

[-h, --help] ([-s, --silent] | [-v, --verbose])
```


## Description

You can specify one of the following modes: `ca`, `cert`, `csr`, `http`. The `elasticsearch-certutil` command also supports a silent mode of operation to enable easier batch operations.

### CA mode

The `ca` mode generates a new certificate authority (CA). By default, it produces a single PKCS#12 output file, which holds the CA certificate and the private key for the CA. If you specify the `--pem` parameter, the command generates a zip file, which contains the certificate and private key in PEM format.
You can subsequently use these files as input for the `cert` mode of the command.

### CERT mode

The `cert` mode generates X.509 certificates and private keys. By default, it produces a single certificate and key for use on a single instance.
To generate certificates and keys for multiple instances, specify the `--multiple` parameter, which prompts you for details about each instance. Alternatively, you can use the `--in` parameter to specify a YAML file that contains details about the instances.
An instance is any piece of the Elastic Stack that requires a TLS or SSL certificate. Depending on your configuration, Elasticsearch, Logstash, Kibana, and Beats might all require a certificate and private key. The minimum required information for an instance is its name, which is used as the common name for the certificate. The instance name can be a hostname value or a full distinguished name. If the instance name would result in an invalid file or directory name, you must also specify a file name in the `--name` command parameter or in the `filename` field in an input YAML file.
You can optionally provide IP addresses or DNS names for each instance. If neither IP addresses nor DNS names are specified, the Elastic Stack products cannot perform hostname verification and you might need to configure the `verification_mode` security setting to `certificate` only. For more information about this setting, see [Security settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings).
All certificates that are generated by this command are signed by a CA unless the `--self-signed` parameter is specified. You must provide your own CA with the `--ca` or `--ca-cert` and `--ca-key` parameters unless `--self-signed` is specified. For more information about generating a CA, see the [CA mode of this command](#certutil-ca). To generate self-signed certificates, use the `--self-signed` parameter.
By default, the `cert` mode produces a single PKCS#12 output file which holds the instance certificate, the instance private key, and the CA certificate. If you specify the `--pem` parameter, the command generates PEM formatted certificates and keys and packages them into a zip file. If you specify the `--multiple` or `--in` parameters, the command produces a zip file containing the generated certificates and keys.

### CSR mode

The `csr` mode generates certificate signing requests (CSRs) that you can send to a trusted certificate authority to obtain signed certificates. The signed certificates must be in PEM or PKCS#12 format to work with Elasticsearch security features.
By default, the command produces a single CSR for a single instance.
To generate CSRs for multiple instances, specify the `--multiple` parameter, which prompts you for details about each instance. Alternatively, you can use the `--in` parameter to specify a YAML file that contains details about the instances.
The `csr` mode produces a single zip file which contains the CSRs and the private keys for each instance. Each CSR is provided as a standard PEM encoding of a PKCS#10 CSR. Each key is provided as a PEM encoding of an RSA private key.

### HTTP mode

The `http` mode guides you through the process of generating certificates for use on the HTTP (REST) interface for Elasticsearch. It asks you a number of questions in order to generate the right set of files for your needs. For example, depending on your choices, it might generate a zip file that contains a certificate authority (CA), a certificate signing request (CSR), or certificates and keys for use in Elasticsearch and Kibana. Each folder in the zip file contains a readme that explains how to use the files.

## Parameters

<definitions>
  <definition term="ca">
    Specifies to generate a new local certificate authority (CA). This parameter cannot be used with the `csr`, `cert` or `http` parameters.
  </definition>
  <definition term="cert">
    Specifies to generate new X.509 certificates and keys. This parameter cannot be used with the `csr`, `ca` or `http` parameters.
  </definition>
  <definition term="csr">
    Specifies to generate certificate signing requests. This parameter cannot be used with the `ca`, `cert` or `http` parameters.
  </definition>
  <definition term="http">
    Generates a new certificate or certificate request for the Elasticsearch HTTP interface. This parameter cannot be used with the `ca`, `cert` or `csr` parameters.
  </definition>
  <definition term="--ca <file_path>">
    Specifies the path to an existing CA key pair (in PKCS#12 format). This parameter is only applicable to the `cert` parameter.
  </definition>
  <definition term="--ca-cert <file_path>">
    Specifies the path to an existing CA certificate (in PEM format). You must also specify the `--ca-key` parameter. The `--ca-cert` parameter is only applicable to the `cert` parameter.
  </definition>
  <definition term="--ca-dn <name>">
    Defines the *Distinguished Name* (DN) that is used for the generated CA certificate. The default value is `CN=Elastic Certificate Tool Autogenerated CA`. This parameter cannot be used with the `csr` or `http` parameters.
  </definition>
  <definition term="--ca-key <file_path>">
    Specifies the path to an existing CA private key (in PEM format). You must also specify the `--ca-cert` parameter. The `--ca-key` parameter is only applicable to the `cert` parameter.
  </definition>
  <definition term="--ca-pass <password>">
    Specifies the password for an existing CA private key or the generated CA private key. This parameter is only applicable to the `cert` parameter
  </definition>
  <definition term="--keyusage <key_usages>">
    Specifies a comma-separated list of key usage restrictions (as per RFC 5280) that are used for the generated CA certificate. The default value is `keyCertSign,cRLSign`. This parameter may only be used with the `ca` parameter.
  </definition>
  <definition term="--days <n>">
    Specifies an integer value that represents the number of days the generated certificates are valid. The default value is `1095`. This parameter cannot be used with the `csr` or `http` parameters.
  </definition>
  <definition term="--dns <domain_name>">
    Specifies a comma-separated list of DNS names. This parameter cannot be used with the `ca` or `http` parameters.
  </definition>
  <definition term="-E <KeyValuePair>">
    Configures a setting.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="--in <input_file>">
    Specifies the file that is used to run in silent mode. The input file must be a YAML file. This parameter cannot be used with the `ca` or `http` parameters.
  </definition>
  <definition term="--ip <IP_addresses>">
    Specifies a comma-separated list of IP addresses. This parameter cannot be used with the `ca` or `http` parameters.
  </definition>
  <definition term="--keysize <bits>">
    Defines the number of bits that are used in generated RSA keys. The default value is `2048`. This parameter cannot be used with the `http` parameter.
  </definition>
  <definition term="--multiple">
    Specifies to generate files for multiple instances. This parameter cannot be used with the `ca` or `http` parameters.
  </definition>
  <definition term="--name <file_name>">
    Specifies the name of the generated certificate. This parameter cannot be used with the `ca` or `http` parameters.
  </definition>
  <definition term="--out <file_path>">
    Specifies a path for the output files. This parameter cannot be used with the `http` parameter.
  </definition>
  <definition term="--pass <password>">
    Specifies the password for the generated private keys. This parameter cannot be used with the `http` parameters.
    Keys stored in PKCS#12 format are always password protected, however, this password may be *blank*. If you want to specify a blank password without a prompt, use `--pass ""` (with no `=`) on the command line.
    Keys stored in PEM format are password protected only if the `--pass` parameter is specified. If you do not supply an argument for the `--pass` parameter, you are prompted for a password. Encrypted PEM files do not support blank passwords (if you do not wish to password-protect your PEM keys, then do not specify `--pass`).
  </definition>
  <definition term="--pem">
    Generates certificates and keys in PEM format instead of PKCS#12. This parameter cannot be used with the `csr` or `http` parameters.
  </definition>
  <definition term="--self-signed">
    Generates self-signed certificates. This parameter is only applicable to the `cert` parameter.
    <note>
      This option is not recommended for [setting up TLS on a cluster](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security#encrypt-internode-communication). In fact, a self-signed certificate should be used only when you can be sure that a CA is definitely not needed and trust is directly given to the certificate itself.
    </note>
  </definition>
  <definition term="-s, --silent">
    Shows minimal output.
  </definition>
  <definition term="-v, --verbose">
    Shows verbose output.
  </definition>
</definitions>


## Examples

The following command generates a CA certificate and private key in PKCS#12 format:
```sh
bin/elasticsearch-certutil ca
```

You are prompted for an output filename and a password. Alternatively, you can specify the `--out` and `--pass` parameters.
You can then generate X.509 certificates and private keys by using the new CA. For example:
```sh
bin/elasticsearch-certutil cert --ca elastic-stack-ca.p12
```

You are prompted for the CA password and for an output filename and password. Alternatively, you can specify the `--ca-pass`, `--out`, and `--pass` parameters.
By default, this command generates a file called `elastic-certificates.p12`, which you can copy to the relevant configuration directory for each Elastic product that you want to configure. For more information, see [Encrypt internode communications with TLS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security#encrypt-internode-communication).

### Using `elasticsearch-certutil` in Silent Mode

To use the silent mode of operation, you must create a YAML file that contains information about the instances. It must match the following format:
```yaml
instances:
  - name: "node1" 
    ip: 
      - "192.0.2.1"
    dns: 
      - "node1.mydomain.com"
  - name: "node2"
    ip:
      - "192.0.2.2"
      - "198.51.100.1"
  - name: "node3"
  - name: "node4"
    dns:
      - "node4.mydomain.com"
      - "node4.internal"
  - name: "CN=node5,OU=IT,DC=mydomain,DC=com"
    filename: "node5" 
```

When your YAML file is ready, you can use the `elasticsearch-certutil` command to generate certificates or certificate signing requests. Simply use the `--in` parameter to specify the location of the file. For example:
```sh
bin/elasticsearch-certutil cert --silent --in instances.yml --out test1.zip --pass testpassword --ca elastic-stack-ca.p12
```

This command generates a compressed `test1.zip` file. After you decompress the output file, there is a directory for each instance that was listed in the `instances.yml` file. Each instance directory contains a single PKCS#12 (`.p12`) file, which contains the instance certificate, instance private key, and CA certificate.
You can also use the YAML file to generate certificate signing requests. For example:
```sh
bin/elasticsearch-certutil csr --silent --in instances.yml --out test2.zip --pass testpassword
```

This command generates a compressed file, which contains a directory for each instance. Each instance directory contains a certificate signing request (`*.csr` file) and private key (`*.key` file).