﻿---
title: elasticsearch-certgen
description: The elasticsearch-certgen command simplifies the creation of certificate authorities (CA), certificate signing requests (CSR), and signed certificates...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certgen
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# elasticsearch-certgen
<admonition title="Deprecated in 6.1.">
  Replaced by [`elasticsearch-certutil`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil).
</admonition>

The `elasticsearch-certgen` command simplifies the creation of certificate authorities (CA), certificate signing requests (CSR), and signed certificates for use with the Elastic Stack. Though this command is deprecated, you do not need to replace CAs, CSRs, or certificates that it created.

## Synopsis

```shell
bin/elasticsearch-certgen
(([--cert <cert_file>] [--days <n>] [--dn <name>] [--key <key_file>]
[--keysize <bits>] [--pass <password>] [--p12 <password>])
| [--csr])
[-E <KeyValuePair>] [-h, --help] [--in <input_file>] [--out <output_file>]
([-s, --silent] | [-v, --verbose])
```


## Description

By default, the command runs in interactive mode and you are prompted for information about each instance. An instance is any piece of the Elastic Stack that requires a Transport Layer Security (TLS) or SSL certificate. Depending on your configuration, Elasticsearch, Logstash, Kibana, and Beats might all require a certificate and private key.
The minimum required value for each instance is a name. This can simply be the hostname, which is used as the Common Name of the certificate. You can also use a full distinguished name. IP addresses and DNS names are optional. Multiple values can be specified as a comma separated string. If no IP addresses or DNS names are provided, you might disable hostname verification in your TLS or SSL configuration.
Depending on the parameters that you specify, you are also prompted for necessary information such as the path for the output file and the CA private key password.
The `elasticsearch-certgen` command also supports a silent mode of operation to enable easier batch operations. For more information, see [Using `elasticsearch-certgen` in Silent Mode](#certgen-silent).
The output file is a zip file that contains the signed certificates and private keys for each instance. If you chose to generate a CA, which is the default behavior, the certificate and private key are included in the output file. If you chose to generate CSRs, you should provide them to your commercial or organization-specific certificate authority to obtain signed certificates. The signed certificates must be in PEM format to work with the Elastic Stack security features.

## Parameters

<definitions>
  <definition term="--cert <cert_file>">
    Specifies to generate new instance certificates and keys using an existing CA certificate, which is provided in the `<cert_file>` argument. This parameter cannot be used with the `-csr` parameter.
  </definition>
  <definition term="--csr">
    Specifies to operate in certificate signing request mode.
  </definition>
  <definition term="--days <n>">
    Specifies an integer value that represents the number of days the generated keys are valid. The default value is `1095`. This parameter cannot be used with the `-csr` parameter.
  </definition>
  <definition term="--dn <name>">
    Defines the *Distinguished Name* that is used for the generated CA certificate. The default value is `CN=Elastic Certificate Tool Autogenerated CA`. This parameter cannot be used with the `-csr` parameter.
  </definition>
  <definition term="-E <KeyValuePair>">
    Configures a setting.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="--in <input_file>">
    Specifies the file that is used to run in silent mode. The input file must be a YAML file, as described in [Using `elasticsearch-certgen` in Silent Mode](#certgen-silent).
  </definition>
  <definition term="--key <key_file>">
    Specifies the *private-key* file for the CA certificate. This parameter is required whenever the `-cert` parameter is used.
  </definition>
  <definition term="--keysize <bits>">
    Defines the number of bits that are used in generated RSA keys. The default value is `2048`.
  </definition>
  <definition term="--out <output_file>">
    Specifies a path for the output file.
  </definition>
  <definition term="--pass <password>">
    Specifies the password for the CA private key. If the `-key` parameter is provided, then this is the password for the existing private key file. Otherwise, it is the password that should be applied to the generated CA key. This parameter cannot be used with the `-csr` parameter.
  </definition>
  <definition term="--p12 <password>">
    Generate a PKCS#12 (`.p12` or `.pfx`) container file for each of the instance certificates and keys. The generated file is protected by the supplied password, which can be blank. This parameter cannot be used with the `-csr` parameter.
  </definition>
  <definition term="-s, --silent">
    Shows minimal output.
  </definition>
  <definition term="-v, --verbose">
    Shows verbose output.
  </definition>
</definitions>


## Examples


### Using `elasticsearch-certgen` in Silent Mode

To use the silent mode of operation, you must create a YAML file that contains information about the instances. It must match the following format:
```yaml
instances:
  - name: "node1" 
    ip: 
      - "192.0.2.1"
    dns: 
      - "node1.mydomain.com"
  - name: "node2"
    ip:
      - "192.0.2.2"
      - "198.51.100.1"
  - name: "node3"
  - name: "node4"
    dns:
      - "node4.mydomain.com"
      - "node4.internal"
  - name: "CN=node5,OU=IT,DC=mydomain,DC=com"
    filename: "node5" 
```

When your YAML file is ready, you can use the `elasticsearch-certgen` command to generate certificates or certificate signing requests. Simply use the `-in` parameter to specify the location of the file. For example:
```sh
bin/elasticsearch-certgen -in instances.yml
```

This command generates a CA certificate and private key as well as certificates and private keys for the instances that are listed in the YAML file.