﻿---
title: Command-line tools
description: Elasticsearch includes a set of command-line tools in its bin subdirectory (for example, /usr/share/elasticsearch/bin). These tools support tasks such...
url: https://www.elastic.co/docs/reference/elasticsearch/command-line-tools
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Command-line tools
Elasticsearch includes a set of command-line tools in its `bin` subdirectory (for example, `/usr/share/elasticsearch/bin`). These tools support tasks such as generating TLS/SSL certificates, configuring security settings and user credentials, enrolling or reconfiguring nodes, managing corrupted shards, and other node-level administrative operations that are only possible, or simpler to perform, outside the REST API.
<important>
  The tools are intended for use in self-managed environments and are included with all Elasticsearch software packages and Docker images, but are not accessible in fully managed Elastic Cloud deployments such as Elastic Cloud Hosted or Elastic Cloud Serverless. Similarly, they are not designed for use in Elastic Cloud Enterprise or Elastic Cloud on Kubernetes.
</important>

The following tools are available:
- [*elasticsearch-certgen*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certgen)
- [*elasticsearch-certutil*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil)
- [*elasticsearch-create-enrollment-token*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token)
- [*elasticsearch-croneval*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/elasticsearch-croneval)
- [*elasticsearch-keystore*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/elasticsearch-keystore)
- [*elasticsearch-node*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/node-tool)
- [*elasticsearch-reconfigure-node*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reconfigure-node)
- [*elasticsearch-reset-password*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password)
- [*elasticsearch-saml-metadata*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/saml-metadata)
- [*elasticsearch-setup-passwords*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/setup-passwords)
- [*elasticsearch-shard*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/shard-tool)
- [*elasticsearch-syskeygen*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/syskeygen)
- [*elasticsearch-users*](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/users-command)