﻿---
title: Installation
description: Install the Rubygem for the latest Elasticsearch version by using the following command: Or add the elasticsearch Ruby gem to your Gemfile: You can install...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/installation
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Ruby Client
---

# Installation
Install the Rubygem for the latest Elasticsearch version by using the following command:
```sh
gem install elasticsearch
```

Or add the `elasticsearch` Ruby gem to your Gemfile:
```ruby
gem 'elasticsearch'
```

You can install the Ruby gem for a specific Elasticsearch version by using the following command:
```sh
gem install elasticsearch -v 7.0.0
```

Or you can add a specific version of Elasticsearch to your Gemfile:
```ruby
gem 'elasticsearch', '~> 7.0'
```


## Elasticsearch and Ruby version compatibility

The Elasticsearch client is compatible with currently maintained Ruby versions. We follow Ruby’s own maintenance policy and officially support all currently maintained versions per [Ruby Maintenance Branches](https://www.ruby-lang.org/en/downloads/branches/).
Language clients are forward compatible; meaning that clients support communicating with greater or equal minor versions of Elasticsearch without breaking. It does not mean that the client automatically supports new features of newer Elasticsearch versions; it is only possible after a release of a new client version. For example, a 8.12 client version won’t automatically support the new features of the 8.13 version of Elasticsearch, the 8.13 client version is required for that. Elasticsearch language clients are only backwards compatible with default distributions and without guarantees made.

| Gem Version |     | Elasticsearch Version | Supported |
|-------------|-----|-----------------------|-----------|
| 7.x         | →   | 7.x                   | 7.17      |
| 8.x         | →   | 8.x                   | 8.x       |
| main        | →   | main                  |           |