﻿---
title: Getting started
description: This page guides you through the installation process of the Ruby client, shows you how to instantiate the client, and how to perform basic Elasticsearch...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/getting-started
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Ruby Client
---

# Getting started
This page guides you through the installation process of the Ruby client, shows you how to instantiate the client, and how to perform basic Elasticsearch operations with it.

### Requirements

A currently maintained version of Ruby (3.0+) or JRuby (9.3+).

### Installation

To install the latest version of the client, run the following command:
```shell
gem install elasticsearch
```

Refer to the [*Installation*](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/installation) page to learn more.

### Connecting

You can connect to the Elastic Cloud using an API key and the Elasticsearch endpoint.
```rb
client = Elasticsearch::Client.new(
  cloud_id: '<CloudID>',
  api_key: '<ApiKey>'
)
```

Your Elasticsearch endpoint can be found on the **My deployment** page of your deployment:
![Finding Elasticsearch endpoint](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/images/es_endpoint.jpg)
You can generate an API key on the **Management** page under Security.
![Create API key](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/images/create_api_key.png)
For other connection options, refer to the [*Connecting*](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/connecting) section.

### Operations

Time to use Elasticsearch! This section walks you through the basic, and most important, operations of Elasticsearch. For more operations and more advanced examples, refer to the [*Examples*](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/examples) page.

#### Creating an index

This is how you create the `my_index` index:
```rb
client.indices.create(index: 'my_index')
```


#### Indexing documents

This is a simple way of indexing a document:
```rb
document = { name: 'elasticsearch-ruby' }
response = client.index(index: 'my_index', body: document)
# You can get the indexed document id with:
response['_id']
=> "PlgIDYkBWS9Ngdx5IMy-"
id = response['_id']
```


#### Getting documents

You can get documents by using the following code:
```rb
client.get(index: 'my_index', id: id)
```


#### Searching documents

This is how you can create a single match query with the Ruby client:
```rb
client.search(index: 'my_index', body: { query: { match_all: {} } })
```


#### Updating documents

This is how you can update a document, for example to add a new field:
```rb
client.update(index: 'my_index', id: id, body: { doc: { language: 'Ruby' } })
```


#### Deleting documents

```rb
client.delete(index: 'my_index', id: id)
```


#### Deleting an index

```rb
client.indices.delete(index: 'my_index')
```


## Further reading

- Use [Bulk and Scroll helpers](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby/Helpers) for a more confortable experience with the APIs.