﻿---
title: Operations
description: This page contains the information you need to perform various Elasticsearch operations by using the Client. This section is a crash-course overview of...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/operations
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Operations
This page contains the information you need to perform various Elasticsearch operations by using the Client.
This section is a crash-course overview of the client and its syntax. If you are familiar with Elasticsearch, you’ll notice that the methods are named just like REST endpoints.
You may also notice that the client is configured in a manner that facilitates easy discovery via your IDE. All core actions are available under the `$client` object (indexing, searching, getting, etc). Index and cluster management are located under the `$client->indices()` and `$client->cluster()` objects, respectively.
- [Index management operations](https://www.elastic.co/docs/reference/elasticsearch/clients/php/index_management)
- [Search operations](https://www.elastic.co/docs/reference/elasticsearch/clients/php/search_operations)
- [Indexing documents](https://www.elastic.co/docs/reference/elasticsearch/clients/php/indexing_documents)
- [Getting documents](https://www.elastic.co/docs/reference/elasticsearch/clients/php/getting_documents)
- [Updating documents](https://www.elastic.co/docs/reference/elasticsearch/clients/php/updating_documents)
- [Deleting documents](https://www.elastic.co/docs/reference/elasticsearch/clients/php/deleting_documents)