﻿---
title: Iterators
description: The PHP client includes helpers for iterating through results by page or by hits. Use the SearchResponseIterator to iterate page by page in a search result...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/iterators
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Iterators
The PHP client includes helpers for iterating through results by page or by hits.

## Search response iterator

Use the `SearchResponseIterator` to iterate page by page in a search result using [pagination](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/paginate-search-results).
Here’s an example:
```php
use Elastic\Elasticsearch\Helper\Iterators\SearchResponseIterator;

$search_params = [
    'scroll'      => '5m',
    'index'       => '<name of index>',
    'size'        => 100,
    'body'        => [
        'query' => [
            'match_all' => new StdClass
        ]
    ]
];
// $client is Elasticsearch\Client instance
$pages = new SearchResponseIterator($client, $search_params);

// Sample usage of iterating over page results
foreach($pages as $page) {
    // do something with hit e.g. copy its data to another index
    // e.g. prints the number of document per page (100)
    echo count($page['hits']['hits']), PHP_EOL;
}
```


### Search hit iterator

Use the `SearchHitIterator` to iterate in a `SearchResponseIterator` without worrying about [pagination](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/paginate-search-results).
Here’s an example:
```php
use Elastic\Elasticsearch\Helper\Iterators\SearchHitIterator;
use Elastic\Elasticsearch\Helper\Iterators\SearchResponseIterator;

$search_params = [
    'scroll'      => '5m',
    'index'       => '<name of index>',
    'size'        => 100,
    'body'        => [
        'query' => [
            'match_all' => new StdClass
        ]
    ]
];
// $client is Elasticsearch\Client instance
$pages = new SearchResponseIterator($client, $search_params);
$hits = new SearchHitIterator($pages);

// Sample usage of iterating over hits
foreach($hits as $hit) {
    // do something with hit e.g. write to CSV, update a database, etc
    // e.g. prints the document id
    echo $hit['_id'], PHP_EOL;
}
```