﻿---
title: Installation
description: Elasticsearch-php can be used starting from PHP 7.4. To install the library you need to use composer with the following command: If you don’t have composer...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/installation
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Installation
Elasticsearch-php can be used starting from PHP 7.4. To install the library you need to use [composer](http://getcomposer.org) with the following command:
```shell
composer require elasticsearch/elasticsearch
```

If you don’t have composer you can install it as follows:
```shell
curl -s http://getcomposer.org/installer | php
php composer.phar install
```

More information about [Composer can be found at their website](https://getcomposer.org/).
When you have installed elasticsearch-php you can start using it with the `Client` class. You can use the `ClientBuilder` class to create this object, as follows:
```php
require 'vendor/autoload.php';

$client = Elastic\Elasticsearch\ClientBuilder::create()->build();
```

- Client instantiation is performed with a static helper function `create()`. This creates a ClientBuilder object, which helps you to set custom configurations. When you are done configuring, call the `build()` method to generate a `Client` object. For further info, consult the [*Configuration*](https://www.elastic.co/docs/reference/elasticsearch/clients/php/configuration) section.