﻿---
title: Host Configuration
description: The client offers an options to configure hosts. The most common configuration is telling the client about your cluster: the number of nodes, their addresses,...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/host-config
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Host Configuration
The client offers an options to configure hosts.
The most common configuration is telling the client about your cluster: the number of nodes, their addresses, and ports. If no hosts are specified, the client attempts to connect to `localhost:9200`.
This behavior can be changed by using the `setHosts()` method on `ClientBuilder`. The method accepts an array of values, each entry corresponding to one node in your cluster. The format of the host can vary, depending on your needs (ip vs hostname, port, ssl, etc).
```php
$hosts = [
    '192.0.2.0:9200',        
    '192.0.2.0',             
    'mydomain.server.com:9201',
    'mydomain2.server.com',    
    'https://localhost',       
    'https://192.0.2.0:9200' 
];
$client = ClientBuilder::create()          
                    ->setHosts($hosts)     
                    ->build();             
```

Notice that the `ClientBuilder` object allows chaining method calls for brevity. It is also possible to call the methods individually:
```php
$hosts = [
    '192.0.2.0:9200',        
    '192.0.2.0',             
    'mydomain.server.com:9201',
    'mydomain2.server.com',    
    'https://localhost',       
    'https://192.0.2.0:9200' 
];
$clientBuilder = ClientBuilder::create();  
$clientBuilder->setHosts($hosts);          
$client = $clientBuilder->build();         
```