﻿---
title: Getting documents
description: Elasticsearch provides realtime GETs of documents. This means that as soon as the document is indexed and your client receives an acknowledgement, you...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/getting_documents
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Getting documents
Elasticsearch provides realtime GETs of documents. This means that as soon as the document is indexed and your client receives an acknowledgement, you can immediately retrieve the document from any shard. Get operations are performed by requesting a document by its full `index/type/id` path:
```php
$params = [
    'index' => 'my_index',
    'id'    => 'my_id'
];

// Get doc at /my_index/_doc/my_id
$response = $client->get($params);
```