﻿---
title: Configuration
description: Almost every aspect of the client is configurable. Most users only need to configure a few parameters to suit their needs, but it is possible to completely...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/php/configuration
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch PHP Client
---

# Configuration
Almost every aspect of the client is configurable. Most users only need to configure a few parameters to suit their needs, but it is possible to completely replace much of the internals if required.
Custom configuration is accomplished before the client is instantiated, through the `ClientBuilder` class. You can find all the configuration options and check sample code that helps you replace the various components.
To learn more about JSON in PHP, read [Dealing with JSON arrays and objects in PHP](https://www.elastic.co/docs/reference/elasticsearch/clients/php/php_json_objects).
- [Host Configuration](https://www.elastic.co/docs/reference/elasticsearch/clients/php/host-config)
- [Set retries](https://www.elastic.co/docs/reference/elasticsearch/clients/php/set-retries)
- [HTTP Meta Data](https://www.elastic.co/docs/reference/elasticsearch/clients/php/http-meta-data)
- [Enabling the Logger](https://www.elastic.co/docs/reference/elasticsearch/clients/php/enabling_logger)
- [Configure the HTTP client](https://www.elastic.co/docs/reference/elasticsearch/clients/php/http-client)
- [Namespaces](https://www.elastic.co/docs/reference/elasticsearch/clients/php/namespaces)
- [Node Pool](https://www.elastic.co/docs/reference/elasticsearch/clients/php/node_pool)
- [Building the client from a configuration hash](/docs/reference/elasticsearch/clients/php/node_pool#config-hash)