﻿---
title: Transport
description: This class is responsible for performing the request to Elasticsearch and handling errors, it also handles sniffing. Sometimes you need to inject a small...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/javascript/transport
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch JavaScript Client
---

# Transport
This class is responsible for performing the request to Elasticsearch and handling errors, it also handles sniffing.
```js
const { Client } = require('@elastic/elasticsearch')
const { Transport } = require('@elastic/transport')

class MyTransport extends Transport {
  request (params, options) {
    // your code
  }
}

const client = new Client({
    Transport: MyTransport
})
```

Sometimes you need to inject a small snippet of your code and then continue to use the usual client code. In such cases, call `super.method`:
```js
class MyTransport extends Transport {
  request (params, options) {
    // your code
    return super.request(params, options)
  }
}
```


## Supported content types

Depending on the `content-type` of the response, the transport will return the body as different types:

| Content-Type                                 | JavaScript type |
|----------------------------------------------|-----------------|
| `application/json`                           | `object`        |
| `text/plain`                                 | `string`        |
| `application/vnd.elasticsearch+json`         | `object`        |
| `application/vnd.mapbox-vector-tile`         | `Buffer`        |
| `application/vnd.apache.arrow.stream`        | `Buffer`        |
| `application/vnd.elasticsearch+arrow+stream` | `Buffer`        |
| `application/smile`                          | `Buffer`        |
| `application/vnd.elasticsearch+smile`        | `Buffer`        |
| `application/cbor`                           | `Buffer`        |
| `application/vnd.elasticsearch+cbor`         | `Buffer`        |