﻿---
title: Timeout best practices
description: Starting in 9.0.0, this client is configured to not time out any HTTP request by default. Elasticsearch will always eventually respond to any request,...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/javascript/timeout-best-practices
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch JavaScript Client
---

# Timeout best practices
Starting in 9.0.0, this client is configured to not time out any HTTP request by default. Elasticsearch will always eventually respond to any request, even if it takes several minutes. Reissuing a request that it has not responded to yet can cause performance side effects. See the [official Elasticsearch recommendations for HTTP clients](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#_http_client_configuration) for more information.
Prior to 9.0, this client was configured by default to operate like many HTTP client libraries do, by using a relatively short (30 second) timeout on all requests sent to Elasticsearch, raising a `TimeoutError` when that time period elapsed without receiving a response.
If you need to set timeouts on Elasticsearch requests, setting the `requestTimeout` value to a millisecond value will cause this client to operate as it did prior to 9.0.