﻿---
title: Using the Java API client
description: The Elasticsearch API reference provides examples of requests in various languages, including Java, available in the dropdown menu on the right. Create...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Using the Java API client
## Code Examples

The Elasticsearch [API reference](https://www.elastic.co/docs/api/doc/elasticsearch/) provides examples of requests in various languages, including Java, available in the dropdown menu on the right.
![Create API java example](https://www.elastic.co/docs/reference/elasticsearch/clients/java/images/create-api-java-example.png)

## General Usage

The sections below provide tutorials on the most frequently used and some less obvious features of Elasticsearch.
For a full reference, see the [Elasticsearch documentation](https://www.elastic.co/docs/get-started) and in particular the [REST APIs](https://www.elastic.co/docs/reference/elasticsearch/rest-apis) section. The Java API Client follows closely the JSON structures described there, using the [Java API conventions](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions).
If you’re new to Elasticsearch, make sure also to read [Elasticsearch’s quick start](https://www.elastic.co/docs/solutions/search/get-started) that provides a good introduction.
- [ES|QL in the Java client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/esql)
- [Indexing single documents](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/indexing)
- [Bulk: indexing multiple documents](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/indexing-bulk)
- [Reading documents by id](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/reading)
- [Searching for documents](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/searching)
- [Aggregations](https://www.elastic.co/docs/reference/elasticsearch/clients/java/usage/aggregations)

<note>
  This is still a work in progress, more sections will be added in the near future.
</note>