﻿---
title: Initializing the Elasticsearch Java REST 5 client
description: A Rest5Client instance can be built through the corresponding Rest5ClientBuilder class, created via Rest5Client#builder(...) static method. The only required...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client/usage/initialization
products:
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Initializing the Elasticsearch Java REST 5 client
A `Rest5Client` instance can be built through the corresponding `Rest5ClientBuilder` class, created via `Rest5Client#builder(...)` static method. The only required argument is one or more URLs or `HttpHost` that the client will communicate with as follows:
```java
Rest5Client restClient = Rest5Client.builder(
    URI.create("http://localhost:9200"),
    URI.create("http://localhost:9201")
).build();
```

The `RestClient` class is thread-safe and ideally has the same lifecycle as the application that uses it. It is important that it gets closed when no longer needed so that all the resources used by it get properly released, as well as the underlying http client instance and its threads:
```java
restClient.close();
```

`RestClientBuilder` also allows to optionally set the following configuration parameters while building the `RestClient` instance:
```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("http", "localhost", 9200));

Header[] defaultHeaders = new Header[]{new BasicHeader("header", "value")};
builder.setDefaultHeaders(defaultHeaders);
```

```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("http", "localhost", 9200));

builder.setFailureListener(new Rest5Client.FailureListener() {
    @Override
    public void onFailure(Node node) {
       
    }
});
```

```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("http", "localhost", 9200));

builder.setNodeSelector(NodeSelector.SKIP_DEDICATED_MASTERS);
```