﻿---
title: Other authentication methods in the Elasticsearch Java REST 5 client
description: If you want the client to authenticate with an Elasticsearch access token, set the relevant HTTP request header. If the client makes requests on behalf...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client/config/other_authentication_methods
products:
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Other authentication methods in the Elasticsearch Java REST 5 client
## Elasticsearch Token Service tokens

If you want the client to authenticate with an Elasticsearch access token, set the relevant HTTP request header. If the client makes requests on behalf of a single user only, you can set the necessary `Authorization` header as a default header as shown in the following example:
```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("https", "localhost", 9200));

Header[] defaultHeaders = new Header[]{ new BasicHeader(
    "Authorization",
    "Bearer u6iuAxZ0RG1Kcm5jVFI4eU4tZU9aVFEwT2F3"
)};

builder.setDefaultHeaders(defaultHeaders);
```


## Elasticsearch API keys

If you want the client to authenticate with an Elasticsearch API key, set the relevant HTTP request header. If the client makes requests on behalf of a single user only, you can set the necessary `Authorization` header as a default header as shown in the following example:
```java
String apiKeyId = "uqlEyn8B_gQ_jlvwDIvM";
String apiKeySecret = "HxHWk2m4RN-V_qg9cDpuX";
String apiKeyAuth = Base64.getEncoder().encodeToString(
        (apiKeyId + ":" + apiKeySecret).getBytes(StandardCharsets.UTF_8)
);

Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("https", "localhost", 9200));

Header[] defaultHeaders = new Header[]{ new BasicHeader(
    "Authorization",
    "ApiKey " + apiKeyAuth
)};

builder.setDefaultHeaders(defaultHeaders);
```