﻿---
title: Maven repository for Elasticsearch Java REST client sniffer
description: The REST client sniffer is subject to the same release cycle as Elasticsearch. Replace the version with the desired sniffer version, first released with...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/sniffer/maven_repository
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Maven repository for Elasticsearch Java REST client sniffer
<note>
  This is the legacy RestClient. Please migrate to [Rest5Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client), a drop-in replacement with an up-to-date http library.
</note>

The REST client sniffer is subject to the same release cycle as Elasticsearch. Replace the version with the desired sniffer version, first released with `5.0.0-alpha4`. There is no relation between the sniffer version and the Elasticsearch version that the client can communicate with. Sniffer supports fetching the nodes list from Elasticsearch 2.x and onwards.
If you are looking for a SNAPSHOT version, the Elastic Maven Snapshot repository is available at [[https://snapshots.elastic.co/maven/](https://snapshots.elastic.co/maven/)](https://snapshots.elastic.co/maven/).

## Maven configuration

Here is how you can configure the dependency using maven as a dependency manager. Add the following to your `pom.xml` file:
```xml
<dependency>
    <groupId>org.elasticsearch.client</groupId>
    <artifactId>elasticsearch-rest-client-sniffer</artifactId>
    <version>9.3.0</version>
</dependency>
```


## Gradle configuration

Here is how you can configure the dependency using gradle as a dependency manager. Add the following to your `build.gradle` file:
```groovy
dependencies {
    compile 'org.elasticsearch.client:elasticsearch-rest-client-sniffer:9.3.0'
}
```