﻿---
title: Other configuration options in the Elasticsearch Java REST client
description: For any other required configuration needed, the Apache HttpAsyncClient docs should be consulted: https://hc.apache.org/httpcomponents-asyncclient-4.1.x/...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/config/others
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Other configuration options in the Elasticsearch Java REST client
<note>
  This is the legacy RestClient. Please migrate to [Rest5Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client), a drop-in replacement with an up-to-date http library.
</note>

For any other required configuration needed, the Apache HttpAsyncClient docs should be consulted: [[https://hc.apache.org/httpcomponents-asyncclient-4.1.x/](https://hc.apache.org/httpcomponents-asyncclient-4.1.x/)](https://hc.apache.org/httpcomponents-asyncclient-4.1.x/) .
<note>
  If your application runs under the security manager you might be subject to the JVM default policies of caching positive hostname resolutions indefinitely and negative hostname resolutions for ten seconds. If the resolved addresses of the hosts to which you are connecting the client to vary with time then you might want to modify the default JVM behavior. These can be modified by adding [`networkaddress.cache.ttl=<timeout>`](https://docs.oracle.com/javase/8/docs/technotes/guides/net/properties.md) and [`networkaddress.cache.negative.ttl=<timeout>`](https://docs.oracle.com/javase/8/docs/technotes/guides/net/properties.md) to your [Java security policy](https://docs.oracle.com/javase/8/docs/technotes/guides/security/PolicyFiles.md).
</note>