﻿---
title: Setting number of threads in the Elasticsearch Java REST client
description: The Apache Http Async Client starts by default one dispatcher thread, and a number of worker threads used by the connection manager, as many as the number...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/config/number_of_threads
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Setting number of threads in the Elasticsearch Java REST client
<note>
  This is the legacy RestClient. Please migrate to [Rest5Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client), a drop-in replacement with an up-to-date http library.
</note>

The Apache Http Async Client starts by default one dispatcher thread, and a number of worker threads used by the connection manager, as many as the number of locally detected processors (depending on what `Runtime.getRuntime().availableProcessors()` returns). The number of threads can be modified as follows:
```java
RestClientBuilder builder = RestClient.builder(
    new HttpHost("localhost", 9200))
    .setHttpClientConfigCallback(new HttpClientConfigCallback() {
        @Override
        public HttpAsyncClientBuilder customizeHttpClient(
                HttpAsyncClientBuilder httpClientBuilder) {
            return httpClientBuilder.setDefaultIOReactorConfig(
                IOReactorConfig.custom()
                    .setIoThreadCount(1)
                    .build());
        }
    });
```