﻿---
title: Elasticsearch Java REST client configuration
description: As explained in Initialization, the RestClientBuilder supports providing both a RequestConfigCallback and an HttpClientConfigCallback which allow for...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/config
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Elasticsearch Java REST client configuration
<note>
  This is the legacy RestClient. Please migrate to [Rest5Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client), a drop-in replacement with an up-to-date http library.
</note>

As explained in [Initialization](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/usage/initialization), the `RestClientBuilder` supports providing both a `RequestConfigCallback` and an `HttpClientConfigCallback` which allow for any customization that the Apache Async Http Client exposes. Those callbacks make it possible to modify some specific behaviour of the client without overriding every other default configuration that the `RestClient` is initialized with. This section describes some common scenarios that require additional configuration for the low-level Java REST Client.