﻿---
title: Legacy REST Client
description: The low-level client’s features include: minimal dependencies, load balancing across all available nodes, failover in case of node failures and upon specific...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Legacy REST Client
<note>
  This is the legacy RestClient. Please migrate to [Rest5Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest5-client), a drop-in replacement with an up-to-date http library.
</note>

The low-level client’s features include:
- minimal dependencies
- load balancing across all available nodes
- failover in case of node failures and upon specific response codes
- failed connection penalization (whether a failed node is retried depends on how many consecutive times it failed; the more failed attempts the longer the client will wait before trying that same node again)
- persistent connections
- trace logging of requests and responses
- optional automatic [discovery of cluster nodes](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client/sniffer)