﻿---
title: Package structure and namespace clients
description: The Elasticsearch API is large and is organized into feature groups, as can be seen in the Elasticsearch API documentation. The Java API Client follows...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/package-structure
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Package structure and namespace clients
The Elasticsearch API is large and is organized into feature groups, as can be seen in the [Elasticsearch API documentation](https://www.elastic.co/docs/reference/elasticsearch/rest-apis).
The Java API Client follows this structure: feature groups are called “namespaces”, and each namespace is located in a subpackage of `co.elastic.clients.elasticsearch`.
Each of the namespace clients can be accessed from the top level Elasticsearch client. The only exceptions are the “search” and “document” APIs which are located in the `core` subpackage and can be accessed on the main Elasticsearch client object.
The snippet below shows how to use the indices namespace client to create an index (the lambda syntax is explained in [Building API objects](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/building-objects)):
```java
// Create the "products" index
ElasticsearchClient client = ...
client.indices().create(c -> c.index("products"));
```

Namespace clients are very lightweight objects that can be created on the fly.