﻿---
title: Object life cycles and thread safety
description: There are five kinds of objects in the Java API Client with different life cycles: 
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/object-lifecycles
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Object life cycles and thread safety
There are five kinds of objects in the Java API Client with different life cycles:
<definitions>
  <definition term="Object mapper">
    Stateless and thread-safe, but can be costly to create. It’s usually a singleton that is created at application startup and used to create the transport.
  </definition>
  <definition term="Transport">
    Thread-safe, holds network resources through the underlying HTTP client. A transport object is associated with an Elasticsearch cluster and has to be explicitly closed to release the underlying resources such as network connections.
  </definition>
  <definition term="Clients">
    Immutable, stateless and thread-safe. These are very lightweight objects that just wrap a transport and provide API endpoints as methods. Closing a client closes the underlying transport.
  </definition>
  <definition term="Builders">
    Mutable, non thread-safe. Builders are transient objects that should not be reused after calling `build()`.
  </definition>
  <definition term="Requests & other API objects">
    Immutable, thread-safe. If your application uses the same request or same parts of a request over and over, these objects can be prepared in advance and reused across multiple calls over multiple clients with different transports.
  </definition>
</definitions>