﻿---
title: API conventions
description: The Java API Client uses a very consistent code structure, using modern code patterns that make complex requests easier to write and complex responses...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# API conventions
The Java API Client uses a very consistent code structure, using modern code patterns that make complex requests easier to write and complex responses easier to process. The sections below explain these in details.
- [Package structure and namespace clients](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/package-structure)
- [Method naming conventions](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/method-naming)
- [Blocking and asynchronous clients](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/blocking-async)
- [Building API objects](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/building-objects)
- [Lists and maps](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/lists-maps)
- [Variant types](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/variant-types)
- [Object life cycles and thread safety](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/object-lifecycles)
- [Creating API objects from JSON data](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/loading-json)
- [Exceptions](https://www.elastic.co/docs/reference/elasticsearch/clients/java/api-conventions/exception-conventions)