﻿---
title: Java
description: This is the documentation for the official Java API Client for Elasticsearch. The client provides strongly typed requests and responses for all Elasticsearch...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/java
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Java
This is the documentation for the official Java API Client for Elasticsearch. The client provides strongly typed requests and responses for all Elasticsearch APIs.

## Features

- Strongly typed requests and responses for all Elasticsearch APIs.
- Blocking and asynchronous versions of all APIs.
- Use of fluent builders and functional patterns to allow writing concise yet readable code when creating complex nested structures.
- Seamless integration of application classes by using an object mapper such as Jackson or any JSON-B implementation.
- Delegates protocol handling to an http client such as the [Java Low Level REST Client](https://www.elastic.co/docs/reference/elasticsearch/clients/java/transport/rest-client) that takes care of all transport-level concerns: HTTP connection pooling, retries, node discovery, and so on.


## Elasticsearch server compatibility policy

The Elasticsearch Java client is forward compatible; meaning that the client supports communicating with greater or equal minor versions of Elasticsearch without breaking. It does not mean that the client automatically supports new features of newer Elasticsearch versions; it is only possible after a release of a new client version. For example, a 8.12 client version won’t automatically support the new features of the 8.13 version of Elasticsearch, the 8.13 client version is required for that. Elasticsearch language clients are only backwards compatible with default distributions and without guarantees made.

| Elasticsearch Version | Elasticsearch-Java Branch | Supported |
|-----------------------|---------------------------|-----------|
| main                  | main                      |           |
| 9.x                   | 9.x                       | 9.x       |
| 8.x                   | 8.x                       | 8.17      |

Java client releases are synchronized with the Elasticsearch server for major and minor versions, while patches are released independently, to allow for faster bugfixes. This does not affect compatibility: for example, version 8.13.x of the client will be compatible with versions of the server 8.13.y where y >= x.