﻿---
title: Go
description: This is the official Go client for Elasticsearch. Full documentation is hosted at GitHub and PkgGoDev. This documentation provides only an overview of...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/go
products:
  - Elasticsearch
  - Elasticsearch Client
  - Elasticsearch Go Client
---

# Go
This is the official Go client for Elasticsearch.
Full documentation is hosted at [GitHub](https://github.com/elastic/go-elasticsearch) and [PkgGoDev](https://pkg.go.dev/github.com/elastic/go-elasticsearch). This documentation provides only an overview of features.

## Features

- One-to-one mapping with REST API.
- Generalized, pluggable architecture.
- Helpers for convenience.
- Rich set of examples.


## Usage

<tab-set>
  <tab-item title="Low-level API">
    ```go
    package main

    import (
      "context"
      "log"

      "github.com/elastic/go-elasticsearch/v9"
    )

    func main() {
      es, _ := elasticsearch.NewDefaultClient()
      defer es.Close(context.Background())
      log.Println(es.Info())
    }
    ```
  </tab-item>

  <tab-item title="Fully-typed API">
    ```go
    package main

    import (
        "context"
        "log"

        "github.com/elastic/go-elasticsearch/v9"
    )

    func main() {
        es, _ := elasticsearch.NewTypedClient(elasticsearch.Config{
            Addresses: []string{"http://localhost:9200"},
        })
        defer es.Close(context.Background())
        log.Println(es.Info().Do(context.Background()))
    }
    ```
  </tab-item>
</tab-set>

<note>
  Please have a look at the collection of comprehensive examples in the repository at [[https://github.com/elastic/go-elasticsearch/tree/master/\_examples](https://github.com/elastic/go-elasticsearch/tree/master/\_examples)](https://github.com/elastic/go-elasticsearch/tree/master/_examples).
</note>


## Resources

- [Source Code](https://github.com/elastic/go-elasticsearch)
- [API Documentation](https://pkg.go.dev/github.com/elastic/go-elasticsearch)
- [Examples and Recipes](https://github.com/elastic/go-elasticsearch/tree/master/_examples)


## License

Copyright 2019 Elasticsearch.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
```text
http://www.apache.org/licenses/LICENSE-2.0
```

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.