﻿---
title: Logging with Fiddler
description: A web debugging proxy such as Fiddler is a useful way to capture HTTP traffic from a machine, particularly whilst developing against a local Elasticsearch...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/troubleshoot/logging-with-fiddler
products:
  - Elasticsearch
  - Elasticsearch .NET Client
  - Elasticsearch Client
---

# Logging with Fiddler
A web debugging proxy such as [Fiddler](http://www.telerik.com/fiddler) is a useful way to capture HTTP traffic from a machine, particularly whilst developing against a local Elasticsearch cluster.

## Capturing traffic to a remote cluster

To capture traffic against a remote cluster is as simple as launching Fiddler! You may want to also filter traffic to only show requests to the remote cluster by using the filters tab
![Capturing requests to a remote host](https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/images/elasticsearch-client-net-api-capture-requests-remotehost.png)

## Capturing traffic to a local cluster

The .NET Framework is hardcoded not to send requests for `localhost` through any proxies and as a proxy Fiddler will not receive such traffic.
This is easily circumvented by using `ipv4.fiddler` as the hostname instead of `localhost`
```csharp
var isFiddlerRunning = Process.GetProcessesByName("fiddler").Any();
var host = isFiddlerRunning ? "ipv4.fiddler" : "localhost";

var connectionSettings = new ConnectionSettings(new Uri($"http://{host}:9200"))
    .PrettyJson(); 

var client = new ElasticClient(connectionSettings);
```

With Fiddler running, the requests and responses will now be captured and can be inspected in the Inspectors tab
![Inspecting requests and responses](https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/images/elasticsearch-client-net-api-inspect-requests.png)
As before, you may also want to filter traffic to only show requests to `ipv4.fiddler` on the port on which you are running Elasticsearch.
![Capturing requests to localhost](https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/images/elasticsearch-client-net-api-capture-requests-localhost.png)