﻿---
title: Query examples
description: This page demonstrates how to perform a search request. 
url: https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/query
products:
  - Elasticsearch
  - Elasticsearch .NET Client
  - Elasticsearch Client
---

# Query examples
This page demonstrates how to perform a search request.

## Fluent API

```csharp
var response = await client.SearchAsync<Person>(search => search
    .Indices("persons")
    .Query(query => query
        .Term(term => term
            .Field(x => x.FirstName)
            .Value("Florian")
        )
    )
    .Size(10)
);
```


## Object initializer API

```csharp
var response = await client.SearchAsync<Person>(
    new SearchRequest<Person>("persons")
    {
        Query = new Query
        {
            Term = new TermQuery
            {
                Field = Infer.Field<Person>(x => x.FirstName),
                Value = "Florian"
            }
        },
        Size = 10
    }
);
```


## Consume the response

```csharp
foreach (var person in response.Documents)
{
    Console.WriteLine(person.FirstName);
}
```