﻿---
title: Custom mapping examples
description: This page demonstrates how to configure custom mappings on an index. 
url: https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/mappings
products:
  - Elasticsearch
  - Elasticsearch .NET Client
  - Elasticsearch Client
---

# Custom mapping examples
This page demonstrates how to configure custom mappings on an index.

## Configure mappings during index creation

```csharp
await client.Indices.CreateAsync<Person>(index => index
    .Index("index")
    .Mappings(mappings => mappings
        .Properties(properties => properties
            .IntegerNumber(x => x.Age!)
            .Keyword(x => x.FirstName!, keyword => keyword.Index(false))
        )
    )
);
```


## Configure mappings after index creation

```csharp
await client.Indices.PutMappingAsync<Person>(mappings => mappings
    .Indices("index")
    .Properties(properties => properties
        .IntegerNumber(x => x.Age!)
        .Keyword(x => x.FirstName!, keyword => keyword.Index(false))
    )
);
```