﻿---
title: ES|QL in the .NET client
description: This page helps you understand and use ES|QL in the .NET client. There are two ways to use ESQL in the .NET client: Use the Elasticsearch ES|QL API directly:...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/esql
products:
  - Elasticsearch
  - Elasticsearch .NET Client
  - Elasticsearch Client
---

# ES|QL in the .NET client
This page helps you understand and use [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql) in the .NET client.
There are two ways to use ESQL in the .NET client:
- Use the Elasticsearch [ES|QL API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-esql) directly: This is the most flexible approach, but it’s also the most complex because you must handle results in their raw form. You can choose the precise format of results, such as JSON, CSV, or text.
- Use ESQL high-level helpers: These helpers take care of parsing the raw response into something readily usable by the application. Several helpers are available for different use cases, such as object mapping, cursor traversal of results (in development), and dataframes (in development).


## How to use the ES|QL API

The [ES|QL query API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-esql) allows you to specify how results should be returned. You can choose a [response format](https://www.elastic.co/docs/reference/query-languages/esql/esql-rest#esql-rest-format) such as CSV, text, or JSON, then fine-tune it with parameters like column separators and locale.
The following example gets ESQL results as CSV and parses them:
```csharp
var response = await client.Esql.QueryAsync(r => r
	.Query("FROM index")
	.Format("csv")
);
var csvContents = Encoding.UTF8.GetString(response.Data);
```


## Consume ES|QL results

The previous example showed that although the raw ESQL API offers maximum flexibility, additional work is required in order to make use of the result data.
To simplify things, try working with these three main representations of ESQL results (each with its own mapping helper):
- **Objects**, where each row in the results is mapped to an object from your application domain. This is similar to what ORMs (object relational mappers) commonly do.
- **Cursors**, where you scan the results row by row and access the data using column names. This is similar to database access libraries.
- **Dataframes**, where results are organized in a column-oriented structure that allows efficient processing of column data.

```csharp
// ObjectAPI example
var response = await client.Esql.QueryAsObjectsAsync<Person>(x => x.Query("FROM index"));
foreach (var person in response)
{
    // ...
}
```