﻿---
title: Options on ElasticsearchClientSettings
description: The following is a list of available connection configuration options on ElasticsearchClientSettings: Here’s an example to demonstrate setting configuration...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet/_options_on_elasticsearchclientsettings
products:
  - Elasticsearch
  - Elasticsearch .NET Client
  - Elasticsearch Client
---

# Options on ElasticsearchClientSettings
The following is a list of available connection configuration options on `ElasticsearchClientSettings`:
<definitions>
  <definition term="Authentication">
    An implementation of `IAuthenticationHeader` describing what http header to use to authenticate with the product.
    ```
    `BasicAuthentication` for basic authentication
    ```
    ```
    `ApiKey` for simple secret token
    ```
    ```
    `Base64ApiKey` for Elastic Cloud style encoded api keys
    ```
  </definition>
  <definition term="ClientCertificate">
    Use the following certificates to authenticate all HTTP requests. You can also set them on individual request using `ClientCertificates`.
  </definition>
  <definition term="ClientCertificates">
    Use the following certificates to authenticate all HTTP requests. You can also set them on individual request using `ClientCertificates`.
  </definition>
  <definition term="ConnectionLimit">
    Limits the number of concurrent connections that can be opened to an endpoint. Defaults to 80 (see `DefaultConnectionLimit`).
    For Desktop CLR, this setting applies to the `DefaultConnectionLimit` property on the `ServicePointManager` object when creating `ServicePoint` objects, affecting the default `IConnection` implementation.
    For Core CLR, this setting applies to the `MaxConnectionsPerServer` property on the `HttpClientHandler` instances used by the `HttpClient` inside the default `IConnection` implementation.
  </definition>
  <definition term="DeadTimeout">
    The time to put dead nodes out of rotation (this will be multiplied by the number of times they’ve been dead).
  </definition>
  <definition term="DefaultDisableIdInference">
    Disables automatic Id inference for given CLR types.
    The client by default will use the value of a property named `Id` on a CLR type as the `_id` to send to Elasticsearch. Adding a type will disable this behaviour for that CLR type. If `Id` inference should be disabled for all CLR types, use `DefaultDisableIdInference`.
  </definition>
  <definition term="DefaultFieldNameInferrer">
    Specifies how field names are inferred from CLR property names.
    By default, the client camel cases property names. For example, CLR property `EmailAddress` will be inferred as "emailAddress" Elasticsearch document field name.
  </definition>
  <definition term="DefaultIndex">
    The default index to use for a request when no index has been explicitly specified and no default indices are specified for the given CLR type specified for the request.
  </definition>
  <definition term="DefaultMappingFor">
    Specify how the mapping is inferred for a given CLR type. The mapping can infer the index, id and relation name for a given CLR type, as well as control serialization behaviour for CLR properties.
  </definition>
  <definition term="DisableAutomaticProxyDetection">
    Disabled proxy detection on the webrequest, in some cases this may speed up the first connection your appdomain makes, in other cases it will actually increase the time for the first connection. No silver bullet! Use with care!
  </definition>
  <definition term="DisableDirectStreaming">
    When set to true will disable (de)serializing directly to the request and response stream and return a byte[] copy of the raw request and response. Defaults to false.
  </definition>
  <definition term="DisablePing">
    This signals that we do not want to send initial pings to unknown/previously dead nodes and just send the call straightaway.
  </definition>
  <definition term="DnsRefreshTimeout">
    DnsRefreshTimeout for the connections. Defaults to 5 minutes.
  </definition>
  <definition term="EnableDebugMode">
    Turns on settings that aid in debugging like `DisableDirectStreaming()` and `PrettyJson()` so that the original request and response JSON can be inspected. It also always asks the server for the full stack trace on errors.
  </definition>
  <definition term="EnableHttpCompression">
    Enable gzip compressed requests and responses.
  </definition>
  <definition term="EnableHttpPipelining">
    Whether HTTP pipelining is enabled. The default is `true`.
  </definition>
  <definition term="EnableTcpKeepAlive">
    Sets the keep-alive option on a TCP connection.
    For Desktop CLR, sets `ServicePointManager`.`SetTcpKeepAlive`.
  </definition>
  <definition term="EnableTcpStats">
    Enable statistics about TCP connections to be collected when making a request.
  </definition>
  <definition term="GlobalHeaders">
    Try to send these headers for every request.
  </definition>
  <definition term="GlobalQueryStringParameters">
    Append these query string parameters automatically to every request.
  </definition>
  <definition term="MaxDeadTimeout">
    The maximum amount of time a node is allowed to marked dead.
  </definition>
  <definition term="MaximumRetries">
    When a retryable exception occurs or status code is returned this controls the maximum amount of times we should retry the call to Elasticsearch.
  </definition>
  <definition term="MaxRetryTimeout">
    Limits the total runtime including retries separately from `RequestTimeout`. When not specified defaults to `RequestTimeout` which itself defaults to 60 seconds.
  </definition>
  <definition term="MemoryStreamFactory">
    Provides a memory stream factory.
  </definition>
  <definition term="NodePredicate">
    Register a predicate to select which nodes that you want to execute API calls on. Note that sniffing requests omit this predicate and always execute on all nodes. When using an `IConnectionPool` implementation that supports reseeding of nodes, this will default to omitting master only node from regular API calls. When using static or single node connection pooling it is assumed the list of node you instantiate the client with should be taken verbatim.
  </definition>
  <definition term="OnRequestCompleted">
    Allows you to register a callback every time a an API call is returned.
  </definition>
  <definition term="OnBeforeRequest">
    An action to run before a request is made.
  </definition>
  <definition term="PingTimeout">
    The timeout in milliseconds to use for ping requests, which are issued to determine whether a node is alive.
  </definition>
  <definition term="PrettyJson">
    Provide hints to serializer and products to produce pretty, non minified json.
    Note: this is not a guarantee you will always get prettified json.
  </definition>
  <definition term="Proxy">
    If your connection has to go through proxy, use this method to specify the proxy url.
  </definition>
  <definition term="RequestTimeout">
    The timeout in milliseconds for each request to Elasticsearch.
  </definition>
  <definition term="ServerCertificateValidationCallback">
    Register a `ServerCertificateValidationCallback` per request.
  </definition>
  <definition term="SkipDeserializationForStatusCodes">
    Configure the client to skip deserialization of certain status codes, for example, you run Elasticsearch behind a proxy that returns an unexpected json format.
  </definition>
  <definition term="SniffLifeSpan">
    Force a new sniff for the cluster when the cluster state information is older than the specified timespan.
  </definition>
  <definition term="SniffOnConnectionFault">
    Force a new sniff for the cluster state every time a connection dies.
  </definition>
  <definition term="SniffOnStartup">
    Sniff the cluster state immediately on startup.
  </definition>
  <definition term="ThrowExceptions">
    Instead of following a c/go like error checking on response. `IsValid` do throw an exception (except when `SuccessOrKnownError` is false) on the client when a call resulted in an exception on either the client or the Elasticsearch server.
    Reasons for such exceptions could be search parser errors, index missing exceptions, and so on.
  </definition>
  <definition term="TransferEncodingChunked">
    Whether the request should be sent with chunked Transfer-Encoding.
  </definition>
  <definition term="UserAgent">
    The user agent string to send with requests. Useful for debugging purposes to understand client and framework versions that initiate requests to Elasticsearch.
  </definition>
</definitions>


## ElasticsearchClientSettings with ElasticsearchClient

Here’s an example to demonstrate setting configuration options using the client.
```csharp
var settings= new ElasticsearchClientSettings()
    .DefaultMappingFor<Project>(i => i
        .IndexName("my-projects")
        .IdProperty(p => p.Name)
    )
    .EnableDebugMode()
    .PrettyJson()
    .RequestTimeout(TimeSpan.FromMinutes(2));

var client = new ElasticsearchClient(settings);
```