﻿---
title: Community-contributed clients
description: Besides the officially supported Elasticsearch clients, there are a number of clients that have been contributed by the community for various languages...
url: https://www.elastic.co/docs/reference/elasticsearch/clients/community
products:
  - Elasticsearch
---

# Community-contributed clients
<note>
  This is a list of clients submitted by members of the Elastic community. Elastic does not support or endorse these clients.If you'd like to add a new client to this list, please [open a pull request](https://github.com/elastic/elasticsearch/blob/main/CONTRIBUTING.md).
</note>

Besides the [officially supported Elasticsearch clients](https://www.elastic.co/docs/reference/elasticsearch-clients), there are
a number of clients that have been contributed by the community for various languages.

## B4J

- [jElasticsearch](https://www.b4x.com/android/forum/threads/server-jelasticsearch-search-and-text-analytics.73335/): B4J client based on the official Java REST client. **Last release more than a year ago**


## C++

- [elasticlient](https://github.com/seznam/elasticlient): simple library for simplified work with Elasticsearch in C++. **Last commit more than a year ago**


## Clojure

- [Spandex](https://github.com/mpenet/spandex): Clojure client, based on the new official low-level REST client.
- [Elastisch](https://github.com/clojurewerkz/elastisch): Clojure client. **Last commit more than a year ago**


## ColdFusion (CFML)

- [cbElasticSearch](https://www.forgebox.io/view/cbelasticsearch): Native ColdFusion (CFML) support for the ColdBox MVC Platform which provides you with a fluent search interface for Elasticsearch, in addition to a CacheBox Cache provider and a Logbox Appender for logging.


## Erlang

- [erlastic_search](https://github.com/tsloughter/erlastic_search): Erlang client using HTTP. **Last commit more than a year ago**
- [Tirexs](https://github.com/datahogs/tirexs): An [Elixir](https://github.com/elixir-lang/elixir) based API/DSL, inspired by [Tire](https://github.com/karmi/tire). Ready to use in pure Erlang environment. **Last commit more than a year ago**
- [Elixir Bulk Processor](https://github.com/sashman/elasticsearch_elixir_bulk_processor): Dynamically configurable Elixir port of the [Bulk Processor](https://www.elastic.co/guide/en/elasticsearch/client/java-api/current/java-docs-bulk-processor.html). Implemented using GenStages to handle back pressure. **Last commit more than a year ago**


## Go

Also see the [official Elasticsearch Go client](https://www.elastic.co/docs/reference/elasticsearch/clients/go).
- [elastigo](https://github.com/mattbaird/elastigo): Go client. **Last commit more than a year ago**
- [elastic](https://github.com/olivere/elastic): Elasticsearch client for Google Go. **Last commit more than a year ago**
- [elk](https://github.com/softctrl/elk): Golang lib for Elasticsearch client. **Last commit more than a year ago**


## Haskell

- [bloodhound](https://github.com/bitemyapp/bloodhound): Haskell client and DSL.


## Java

Also see the [official Elasticsearch Java client](https://www.elastic.co/docs/reference/elasticsearch/clients/java).
- [Flummi](https://github.com/otto-de/flummi): Java Rest client with comprehensive Query DSL API.
- [Jest](https://github.com/searchbox-io/Jest): Java Rest client. **No longer maintained**


## JavaScript

See the [official Elasticsearch JavaScript client](https://www.elastic.co/docs/reference/elasticsearch/clients/javascript).

## Julia

- [ElasticsearchClient.jl](https://github.com/OpenSesame/ElasticsearchClient.jl): Elasticsearch client inspired by the [official Elasticsearch Ruby client](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby).


## Kotlin

- [ES Kotlin](https://github.com/mbuhot/eskotlin): Elasticsearch Query DSL for kotlin based on the [official Elasticsearch Java client](https://www.elastic.co/docs/reference/elasticsearch/clients/java). **Last commit more than a year ago**
- [ES Kotlin Wrapper Client](https://github.com/jillesvangurp/es-kotlin-wrapper-client): Kotlin extension functions and abstractions for the [official Elasticsearch high-level client](https://www.elastic.co/guide/en/elasticsearch/client/java-api/current/index.html). Aims to reduce the amount of boilerplate needed to do searches, bulk indexing and other common things users do with the client. **No longer maintained**


## Lua

- [elasticsearch-lua](https://github.com/DhavalKapil/elasticsearch-lua): Lua client for Elasticsearch **Last commit more than a year ago**


## .NET

See the [official Elasticsearch .NET client](https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet).

## Perl

Also see the [official Elasticsearch Perl client](https://www.elastic.co/guide/en/elasticsearch/client/perl-api/current/index.html).
- [Elastijk](https://metacpan.org/pod/Elastijk): A low-level, minimal HTTP client. **Last commit more than a year ago**


## PHP

Also see the [official Elasticsearch PHP client](https://www.elastic.co/docs/reference/elasticsearch/clients/php).
- [Elastica](https://github.com/ruflin/Elastica): PHP client.
- [elasticsearch](https://github.com/nervetattoo/elasticsearch): PHP client. **Last commit more than a year ago**
- [elasticsearcher](https://github.com/madewithlove/elasticsearcher): Agnostic lightweight package on top of the Elasticsearch PHP client. Its main goal is to allow for easier structuring of queries and indices in your application. It does not want to hide or replace functionality of the Elasticsearch PHP client. **Last commit more than a year ago**


## Python

See the [official Elasticsearch Python client](https://www.elastic.co/docs/reference/elasticsearch/clients/python).

## R

- [elastic](https://github.com/ropensci/elastic): A low-level R client for Elasticsearch.
- [elasticdsl](https://github.com/ropensci/elasticdsl): A high-level R DSL for Elasticsearch, wrapping the elastic R client. **No longer maintained**
- [uptasticsearch](https://github.com/uptake/uptasticsearch): An R client tailored to data science workflows. **Last commit more than a year ago**


## Ruby

Also see the [official Elasticsearch Ruby client](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby).
- [chewy](https://github.com/toptal/chewy): An ODM and wrapper for the official Elasticsearch client.
- [Searchkick](https://github.com/ankane/searchkick): Intelligent search made easy.
- [Estella](https://github.com/artsy/estella): Make your Ruby models searchable.
- [SearchFlip](https://github.com/mrkamel/search_flip): Full-featured Elasticsearch Ruby Client with a Chainable DSL.
- [elastics](https://github.com/printercu/elastics-rb): Tiny client with built-in zero-downtime migrations and ActiveRecord integration. **Last commit more than a year ago**


## Rust

Also see the [official Elasticsearch Rust client](https://www.elastic.co/docs/reference/elasticsearch/clients/rust).
- [rs-es](https://github.com/benashford/rs-es): A REST API client with a strongly-typed Query DSL. **Last commit more than a year ago**
- [elastic](https://github.com/elastic-rs/elastic): A modular REST API client that supports freeform queries. **Last commit more than a year ago**


## Scala

- [elastic4s](https://github.com/sksamuel/elastic4s): Scala DSL.
- [wabisabi](https://github.com/gphat/wabisabi): Asynchronous REST API Scala client. **No longer maintained**
- [escalar](https://github.com/workday/escalar): Type-safe Scala wrapper for the REST API. **Last commit more than a year ago**
- [elasticsearch-client](https://github.com/SumoLogic/elasticsearch-client): Scala DSL that uses the REST API. Akka and AWS helpers included.**No longer maintained**


## Smalltalk

- [elasticsearch-smalltalk](https://github.com/newapplesho/elasticsearch-smalltalk): Pharo Smalltalk client for Elasticsearch. **Last commit more than a year ago**


## Swift

- [Elasticsearch NIO Client](https://github.com/brokenhandsio/elasticsearch-nio-client): a library for working with Elasticsearch in Swift, built on top of SwiftNIO and Swift Package Manager.


## Vert.x

- [elasticsearch-client](https://github.com/reactiverse/elasticsearch-client): An Elasticsearch client for Eclipse Vert.x **Last commit more than a year ago**