﻿---
title: Elasticsearch
description: Elasticsearch is a distributed search and analytics engine, scalable data store, and vector database built on Apache Lucene. It’s optimized for speed...
url: https://www.elastic.co/docs/reference/elasticsearch
products:
  - Elasticsearch
---

# Elasticsearch
Elasticsearch is a distributed search and analytics engine, scalable data store, and vector database built on Apache Lucene. It’s optimized for speed and relevance on production-scale workloads. Use Elasticsearch to search, index, store, and analyze data of all shapes and sizes in near real time.

## Quick links

<dropdown title="Useful links">
  - [REST API Reference](https://www.elastic.co/docs/reference/elasticsearch/rest-apis)
  - [API Conventions](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions)
  - [Settings Reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/settings.html)
  - [Breaking Changes](https://www.elastic.co/guide/en/elasticsearch/reference/current/breaking-changes.html)
  - [Compatibility](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility)
  - [Glossary](https://www.elastic.co/guide/en/elasticsearch/reference/current/glossary.html)
  - [Plugin Development](https://www.elastic.co/guide/en/elasticsearch/plugins/current/index.html)
  - [Supported Platforms](https://www.elastic.co/support/matrix#matrix_jvm)
</dropdown>


## Setup and architecture

- [Set up Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch)
- [Secure the Elastic Stack](https://www.elastic.co/docs/deploy-manage/security)
- [Upgrade Elasticsearch](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster)
- [Set up a cluster for high availability](https://www.elastic.co/docs/deploy-manage/tools)
- [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring)
- [Troubleshooting](https://www.elastic.co/docs/troubleshoot/elasticsearch)
- [Optimizations](https://www.elastic.co/docs/deploy-manage/production-guidance/optimize-performance)


## Working with data

- [Adding data to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest)
- [Connectors](https://www.elastic.co/docs/reference/search-connectors)
- [Web crawler](https://www.elastic.co/search-labs/blog/elastic-open-crawler-release)
- [Data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams)
- [Ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines)
- [Mapping](https://www.elastic.co/docs/manage-data/data-store/mapping)
- [Data management](https://www.elastic.co/docs/manage-data/lifecycle)
- [Downsampling](https://www.elastic.co/docs/manage-data/lifecycle)
- [Snapshot and restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore)


## Search and analytics

Elasticsearch is the search and analytics engine that powers the Elastic Stack.
- [Get started](https://www.elastic.co/docs/get-started)
- [Learn how to search your data](https://www.elastic.co/docs/solutions/search/querying-for-search)
- Query data programmatically: use query languages to run advanced search, filtering, or analytics
  - [Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl): full JSON-based query language
- [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql): fast, SQL-like language with piped syntax
- [EQL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/eql): for event-based time series data, such as logs, metrics, and traces
- [SQL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/sql): SQL-style queries on Elasticsearch data
- [Search applications](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications)
- [Aggregations](https://www.elastic.co/docs/explore-analyze/query-filter/aggregations)
- [Geospatial analysis](https://www.elastic.co/docs/explore-analyze/geospatial-analysis)
- [Machine Learning](https://www.elastic.co/docs/explore-analyze/machine-learning)
- [Alerting](https://www.elastic.co/docs/explore-analyze/alerts-cases)


## APIs and developer docs

- [REST APIs](https://www.elastic.co/docs/reference/elasticsearch/rest-apis)
- [Elasticsearch Clients](https://www.elastic.co/docs/reference/elasticsearch-clients)
- [Painless](https://www.elastic.co/docs/reference/scripting-languages/painless/painless)
- [Plugins and integrations](https://www.elastic.co/docs/reference/elasticsearch/plugins)
- [Search Labs](https://www.elastic.co/search-labs)
- [Notebook examples](https://www.elastic.co/search-labs/tutorials/examples)