﻿---
title: Elasticsearch for Apache Hadoop reference
description: This part of the documentation explains the core functionality of elasticsearch-hadoop starting with the configuration options and architecture and gradually...
url: https://www.elastic.co/docs/reference/elasticsearch-hadoop/reference
products:
  - Elasticsearch
  - Elasticsearch for Apache Hadoop
---

# Elasticsearch for Apache Hadoop reference
This part of the documentation explains the core functionality of elasticsearch-hadoop starting with the configuration options and architecture and gradually explaining the various major features. At a higher level the reference is broken down into architecture and configuration section which are general, Map/Reduce and the libraries built on top of it, upcoming computation libraries (like Apache Spark) and finally mapping, metrics and troubleshooting.
We recommend going through the entire documentation even superficially when trying out elasticsearch-hadoop for the first time, however those in a rush, can jump directly to the desired sections:
<definitions>
  <definition term="Architecture">
    Overview of the elasticsearch-hadoop architecture and how it maps on top of Hadoop.
  </definition>
  <definition term="Configuration">
    Explore the various configuration switches in elasticsearch-hadoop.
  </definition>
  <definition term="Map/Reduce integration">
    Describes how to use elasticsearch-hadoop in vanilla Map/Reduce environments - typically useful for those interested in data loading and saving to/from Elasticsearch without little, if any, ETL (extract-transform-load).
  </definition>
  <definition term="Apache Hive integration">
    Hive users should refer to this section.
  </definition>
  <definition term="Apache Spark support">
    Describes how to use Apache Spark with Elasticsearch through elasticsearch-hadoop.
  </definition>
  <definition term="Mapping and types">
    A deep-dive into the strategies employed by elasticsearch-hadoop for doing type conversion and mapping to and from Elasticsearch.
  </definition>
  <definition term="Hadoop Metrics">
    Elasticsearch Hadoop metrics.
  </definition>
  <definition term="Troubleshooting">
    Tips on troubleshooting and getting help.
  </definition>
</definitions>