﻿---
title: Download the EDOT Collector
description: Direct download links for EDOT Collector binaries for various operating systems and architectures.
url: https://www.elastic.co/docs/reference/edot-collector/download
products:
  - Elastic Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Download the EDOT Collector
The Elastic Distribution of OpenTelemetry (EDOT) Collector is embedded in the Elastic Agent package as a separate binary that invokes OpenTelemetry Collector components.
The following table contains direct download links for the latest EDOT Collector version for different operating systems and architectures.

| Platform    | Architecture | Download link                                                                                                             |
|-------------|--------------|---------------------------------------------------------------------------------------------------------------------------|
| Linux       | x86_64       | [Download (Tar.gz)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-linux-x86_64.tar.gz)   |
| Linux       | aarch64      | [Download (Tar.gz)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-linux-arm64.tar.gz)    |
| Linux (DEB) | x86_64       | [Download (Deb)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-amd64.deb)                |
| Linux (DEB) | aarch64      | [Download (Deb)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-arm64.deb)                |
| Linux (RPM) | x86_64       | [Download (Rpm)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-x86_64.rpm)               |
| Linux (RPM) | aarch64      | [Download (Rpm)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-aarch64.rpm)              |
| Windows     | x86_64       | [Download (Zip)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-windows-x86_64.zip)       |
| macOS       | x86_64       | [Download (Tar.gz)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-darwin-x86_64.tar.gz)  |
| macOS       | aarch64      | [Download (Tar.gz)](https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-darwin-aarch64.tar.gz) |

After you've downloaded and uncompressed the file, you can get EDOT Collector running with the following command:
```
sudo ./otelcol --config otel.yml
```

For specific configuration, refer to the [Quickstart guides](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) or refer to [Configuration](https://www.elastic.co/docs/reference/edot-collector/config).
<tip>
  To download a specific version of the EDOT Collector, replace 9.3.0 with the version you want to download.
</tip>