﻿---
title: Migrate from deprecated components
description: How to migrate from deprecated EDOT Collector components to their replacements.
url: https://www.elastic.co/docs/reference/edot-collector/components/migrate-components
products:
  - Elastic Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Migrate from deprecated components
This guide explains how to migrate from deprecated EDOT Collector components to their replacements.

## Before you begin

- Make sure your Elastic Stack is running version 9.0.0. If you're using Elastic Stack version 8.18 or 8.19, continue using the deprecated components as specified in the configuration for your Stack version.
- Have access to a staging environment where you can test the new configuration before deploying to production.


## Migrate your configuration

Follow these steps to migrate your existing EDOT Collector configuration.
<stepper>
  <step title="Download the latest default configuration">
    Download the configuration sample that matches your use case from the [default configuration samples](/docs/reference/edot-collector/config/default-config-standalone#agent-mode). For Gateway mode, refer to the [Gateway mode section](/docs/reference/edot-collector/config/default-config-standalone#gateway-mode).The latest configurations for Elastic Stack 9.x use the latest components instead of the deprecated ones.
  </step>

  <step title="Test the new configuration in staging">
    Before deploying to production, validate the new configuration in a staging environment:
    1. Deploy the EDOT Collector with the new configuration to your staging environment.
    2. Verify that telemetry data (logs, metrics, and traces) is being collected and exported correctly.
    3. Check that the data appears correctly in the Elastic Observability UIs in Kibana.
    4. Test any custom pipelines or configurations you might have added on top of the default configuration.

    <tip>
      If you have custom configurations, compare your existing configuration with the new default to identify which sections need updating.
    </tip>
  </step>

  <step title="Apply the new configuration in production">
    After validating the configuration in staging:
    1. Schedule a maintenance window for the update if necessary.
    2. Back up your existing EDOT Collector configuration.
    3. Deploy the new configuration to your production collectors.
    4. Monitor the Elastic Observability UIs to ensure data continues to flow correctly.
  </step>
</stepper>

<important>
  If you're upgrading EDOT Collector to 9.x but keeping your Elastic Stack on 8.18 or 8.19:
  - Use the configuration examples for your Stack version (8.18 or 8.19), not the latest 9.x configuration.
  - Continue using deprecated components that are included in the configuration for your Stack version.
  - These deprecated components are retained in EDOT Collector 9.x specifically to maintain backwards compatibility during the official deprecation window.
</important>


## Related pages

- [Default configuration (standalone)](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone)
- [Components included in the EDOT Collector](https://www.elastic.co/docs/reference/edot-collector/components)