﻿---
title: Components included in the EDOT Collector
description: List of components included in the EDOT Collector, categorized as Core or Extended.
url: https://www.elastic.co/docs/reference/edot-collector/components
products:
  - Elastic Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Components included in the EDOT Collector
The Elastic Distribution of OpenTelemetry (EDOT) Collector includes embedded Collector components from the [OTel Collector Core](https://github.com/open-telemetry/opentelemetry-collector),
[OTel Collector Contrib](https://github.com/open-telemetry/opentelemetry-collector-contrib) and the [Elastic Collector Components](https://github.com/elastic/opentelemetry-collector-components) repositories.
The components included in the EDOT Collector are categorized into **[Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)** and **[Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components)** components. The following table describes the current components included in the EDOT Collector, their source, and support status.
<note>
  Components marked as "Deprecated" in the table are retained in EDOT Collector 9.x to maintain backwards compatibility during the official deprecation window. If you're running EDOT Collector 9.x with Elastic Stack 8.18 or 8.19, continue using these deprecated components as specified in the configuration for your Stack version. For more details, refer to [Configuration compatibility with Elastic Stack versions](/docs/reference/edot-collector/config/default-config-standalone#configuration-compatibility-with-elastic-stack-versions). To migrate your configuration to the new components, refer to [Migrate components](https://www.elastic.co/docs/reference/edot-collector/components/migrate-components).
</note>


## List of components

These components are included in EDOT Collector version 9.3.0.

| Component                                                                                                                                           | GitHub Repo                                                                              | Support status                                                                                                 | Version     |
|-----------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|-------------|
| ***Receivers***                                                                                                                                     |                                                                                          |                                                                                                                |             |
| [apachereceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/apachereceiver)                               | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [awss3receiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/awss3receiver)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [dockerstatsreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/dockerstatsreceiver)                     | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [elasticapmintakereceiver](https://www.elastic.co/docs/reference/edot-collector/components/elasticapmintakereceiver)                                | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.24.0     |
| [filelogreceiver](https://www.elastic.co/docs/reference/edot-collector/components/filelogreceiver)                                                  | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [hostmetricsreceiver](https://www.elastic.co/docs/reference/edot-collector/components/hostmetricsreceiver)                                          | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [httpcheckreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/httpcheckreceiver)                         | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [iisreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/iisreceiver)                                     | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [jaegerreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/jaegerreceiver)                               | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [jmxreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/jmxreceiver)                                     | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [k8sclusterreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/k8sclusterreceiver)                       | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [k8seventsreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/k8seventsreceiver)                         | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [k8sobjectsreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/k8sobjectsreceiver)                       | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [kafkareceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/kafkareceiver)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [kubeletstatsreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/kubeletstatsreceiver)                   | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [mysqlreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/mysqlreceiver)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [nginxreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/nginxreceiver)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [nopreceiver](https://github.com/open-telemetry/opentelemetry-collector/tree/main/receiver/nopreceiver)                                             | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [otlpreceiver](https://github.com/open-telemetry/opentelemetry-collector/tree/main/receiver/otlpreceiver)                                           | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [postgresqlreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/postgresqlreceiver)                       | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [profiling](https://github.com/open-telemetry/opentelemetry-ebpf-profiler)                                                                          | [OTel eBPF Profiler Repo](https://github.com/open-telemetry/opentelemetry-ebpf-profiler) | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.0.202547 |
| [prometheusreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/prometheusreceiver)                       | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [prometheusremotewritereceiver](https://www.elastic.co/docs/reference/edot-collector/components/prometheusremotewritereceiver)                      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [receivercreator](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/receivercreator)                             | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [redisreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/redisreceiver)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [snmpreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/snmpreceiver)                                   | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [sqlserverreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/sqlserverreceiver)                         | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [windowseventlogreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/windowseventlogreceiver)             | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [windowsperfcountersreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/windowsperfcountersreceiver)     | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [zipkinreceiver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/zipkinreceiver)                               | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| ***Exporters***                                                                                                                                     |                                                                                          |                                                                                                                |             |
| [debugexporter](https://github.com/open-telemetry/opentelemetry-collector/tree/main/exporter/debugexporter)                                         | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [elasticsearchexporter](https://www.elastic.co/docs/reference/edot-collector/components/elasticsearchexporter)                                      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [fileexporter](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/fileexporter)                                   | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [kafkaexporter](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/kafkaexporter)                                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [loadbalancingexporter](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/loadbalancingexporter)                 | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [nopexporter](https://github.com/open-telemetry/opentelemetry-collector/tree/main/exporter/nopexporter)                                             | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [otlpexporter](https://github.com/open-telemetry/opentelemetry-collector/tree/main/exporter/otlpexporter)                                           | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [otlphttpexporter](https://github.com/open-telemetry/opentelemetry-collector/tree/main/exporter/otlphttpexporter)                                   | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| ***Processors***                                                                                                                                    |                                                                                          |                                                                                                                |             |
| [attributesprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/attributesprocessor)                    | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [batchprocessor](https://github.com/open-telemetry/opentelemetry-collector/tree/main/processor/batchprocessor)                                      | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [cumulativetodeltaprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/cumulativetodeltaprocessor)      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [elasticapmprocessor](https://www.elastic.co/docs/reference/edot-collector/components/elasticapmprocessor)                                          | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.24.0     |
| [elasticinframetricsprocessor](https://github.com/elastic/opentelemetry-collector-components/tree/main/processor/elasticinframetricsprocessor)      | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | Deprecated                                                                                                     | v0.24.0     |
| [elastictraceprocessor](https://github.com/elastic/opentelemetry-collector-components/tree/main/processor/elastictraceprocessor)                    | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | Deprecated                                                                                                     | v0.24.0     |
| [filterprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/filterprocessor)                            | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [geoipprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/geoipprocessor)                              | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [k8sattributesprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/k8sattributesprocessor)              | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [memorylimiterprocessor](https://github.com/open-telemetry/opentelemetry-collector/tree/main/processor/memorylimiterprocessor)                      | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [resourcedetectionprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/resourcedetectionprocessor)      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [resourceprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/resourceprocessor)                        | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [tailsamplingprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/tailsamplingprocessor)                | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [transformprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/transformprocessor)                      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| ***Connectors***                                                                                                                                    |                                                                                          |                                                                                                                |             |
| [elasticapmconnector](https://www.elastic.co/docs/reference/edot-collector/components/elasticapmconnector)                                          | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.24.0     |
| [forwardconnector](https://github.com/open-telemetry/opentelemetry-collector/tree/main/connector/forwardconnector)                                  | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [profilingmetricsconnector](https://github.com/elastic/opentelemetry-collector-components/tree/main/connector/profilingmetricsconnector)            | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.25.0     |
| [routingconnector](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/connector/routingconnector)                          | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [spanmetricsconnector](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/connector/spanmetricsconnector)                  | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| ***Extensions***                                                                                                                                    |                                                                                          |                                                                                                                |             |
| [apikeyauthextension](https://www.elastic.co/docs/reference/edot-collector/config/authentication-methods)                                           | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.24.0     |
| [apmconfigextension](https://github.com/elastic/opentelemetry-collector-components/tree/main/extension/apmconfigextension)                          | [Elastic Repo](https://github.com/elastic/opentelemetry-collector-components)            | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.24.0     |
| [awslogsencodingextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/encoding/awslogsencodingextension) | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [bearertokenauthextension](https://www.elastic.co/docs/reference/edot-collector/config/authentication-methods)                                      | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [filestorage](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/storage/filestorage)                            | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v0.141.0    |
| [headerssetterextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/headerssetterextension)              | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [healthcheckextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/healthcheckextension)                  | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [healthcheckv2extension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/healthcheckv2extension)              | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [k8sleaderelector](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/k8sleaderelector)                          | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [k8sobserver](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/observer/k8sobserver)                           | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [memorylimiterextension](https://github.com/open-telemetry/opentelemetry-collector/tree/main/extension/memorylimiterextension)                      | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| [pprofextension](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/extension/pprofextension)                              | [OTel Contrib Repo](https://github.com/open-telemetry/opentelemetry-collector-contrib)   | [Extended](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#extended-components) | v0.141.0    |
| ***Providers***                                                                                                                                     |                                                                                          |                                                                                                                |             |
| [envprovider](https://github.com/open-telemetry/opentelemetry-collector/tree/main/confmap/provider/envprovider)                                     | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v1.47.0     |
| [fileprovider](https://github.com/open-telemetry/opentelemetry-collector/tree/main/confmap/provider/fileprovider)                                   | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v1.47.0     |
| [httpprovider](https://github.com/open-telemetry/opentelemetry-collector/tree/main/confmap/provider/httpprovider)                                   | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v1.47.0     |
| [httpsprovider](https://github.com/open-telemetry/opentelemetry-collector/tree/main/confmap/provider/httpsprovider)                                 | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v1.47.0     |
| [yamlprovider](https://github.com/open-telemetry/opentelemetry-collector/tree/main/confmap/provider/yamlprovider)                                   | [OTel Core Repo](https://github.com/open-telemetry/opentelemetry-collector)              | [Core](https://www.elastic.co/docs/reference/opentelemetry/compatibility/nomenclature#core-components)         | v1.47.0     |
The following features and configuration options are **NOT** officially supported in the EDOT Collector with the Kafka receiver:
- Encoding options other than `otlp_proto` or `otlp_json`
- Using the Sarama client (i.e. opting out of the `exporter.kafkaexporter.UseFranzGo` feature gate is not supported)
The following features and configuration options are **NOT** officially supported in the EDOT Collector with the Kafka receiver:
- Encoding options other than `otlp_proto` or `otlp_json`
- Using the Sarama client (i.e. opting out of the `exporter.kafkaexporter.UseFranzGo` feature gate is not supported)
- Partitioning configuration (i.e. `partition_*` options).