﻿---
title: Get started with ECS Logging PHP
description: Elastic\Monolog\v2\Formatter\ElasticCommonSchemaFormatter implements Monolog’s FormatterInterface and thus it can be used when setting up Monolog logger...
url: https://www.elastic.co/docs/reference/ecs/logging/php/setup
products:
  - ECS Logging
  - ECS Logging PHP
---

# Get started with ECS Logging PHP
<note>
  ECS logging for PHP is currently only available for Monolog v2.*.
</note>


## Step 1: Set up application logging


### Add the dependency

```cmd
composer require elastic/ecs-logging
```


### Configure monolog logger

`Elastic\Monolog\v2\Formatter\ElasticCommonSchemaFormatter` implements Monolog’s [`FormatterInterface`](https://github.com/Seldaek/monolog/blob/2.0.0/src/Monolog/Formatter/FormatterInterface.php) and thus it can be used when setting up Monolog logger.
For example:
```php
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Elastic\Monolog\Formatter\ElasticCommonSchemaFormatter;

$log = new Logger('MyLogger');
$handler = new StreamHandler('php://stdout', Logger::DEBUG);
$handler->setFormatter(new ElasticCommonSchemaFormatter());
$log->pushHandler($handler);

$log->warning('Be aware that...');
```

Logs the following JSON to standard output:
```json
{"@timestamp":"2021-02-07T18:08:07.229676Z","log.level":"WARNING","message":"Be aware that...","ecs.version":"1.2.0","log":{"logger":"MyLogger"}}
```

Additionally, it allows for adding additional keys to messages.
For example:
```php
$log->info('My message', ['labels' => ['my_label_key' => 'my_label_value'], 'trace.id' => 'abc-xyz']);
```

Logs the following (multi-line formatted for better readability):
```json
{
    "@timestamp": "2021-02-08T06:36:38.913824Z",
    "log.level": "INFO",
    "message": "My message",
    "ecs.version": "1.2.0",
    "log": {
        "logger": "MyLogger"
    },
    "labels": {
        "my_label_key": "my_label_value"
    },
    "trace.id": "abc-xyz"
}
```


## Step 2: Configure Filebeat

<tab-set>
  <tab-item title="Log file">
    1. Follow the [Filebeat quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)
    2. Add the following configuration to your `filebeat.yaml` file.
    For Filebeat 7.16+
    ```yaml
    filebeat.inputs:
    - type: filestream 
      paths: /path/to/logs.json
      parsers:
        - ndjson:
          overwrite_keys: true 
          add_error_key: true 
          expand_keys: true 

    processors: 
      - add_host_metadata: ~
      - add_cloud_metadata: ~
      - add_docker_metadata: ~
      - add_kubernetes_metadata: ~
    ```
    For Filebeat < 7.16
    ```yaml
    filebeat.inputs:
    - type: log
      paths: /path/to/logs.json
      json.keys_under_root: true
      json.overwrite_keys: true
      json.add_error_key: true
      json.expand_keys: true

    processors:
    - add_host_metadata: ~
    - add_cloud_metadata: ~
    - add_docker_metadata: ~
    - add_kubernetes_metadata: ~
    ```
  </tab-item>

  <tab-item title="Kubernetes">
    1. Make sure your application logs to stdout/stderr.
    2. Follow the [Run Filebeat on Kubernetes](https://www.elastic.co/docs/reference/beats/filebeat/running-on-kubernetes) guide.
    3. Enable [hints-based autodiscover](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover-hints) (uncomment the corresponding section in `filebeat-kubernetes.yaml`).
    4. Add these annotations to your pods that log using ECS loggers. This will make sure the logs are parsed appropriately.

    ```yaml
    annotations:
      co.elastic.logs/json.overwrite_keys: true 
      co.elastic.logs/json.add_error_key: true 
      co.elastic.logs/json.expand_keys: true 
    ```
  </tab-item>

  <tab-item title="Docker">
    1. Make sure your application logs to stdout/stderr.
    2. Follow the [Run Filebeat on Docker](https://www.elastic.co/docs/reference/beats/filebeat/running-on-docker) guide.
    3. Enable [hints-based autodiscover](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover-hints).
    4. Add these labels to your containers that log using ECS loggers. This will make sure the logs are parsed appropriately.

    ```yaml
    labels:
      co.elastic.logs/json.overwrite_keys: true 
      co.elastic.logs/json.add_error_key: true 
      co.elastic.logs/json.expand_keys: true 
    ```
  </tab-item>
</tab-set>

For more information, see the [Filebeat reference](https://www.elastic.co/docs/reference/beats/filebeat/configuring-howto-filebeat).