﻿---
title: ECS Logging Node.js
description: Node.js ECS loggers are formatter plugins for your favorite logging libraries. They make it easy to format your logs into ECS-compatible JSON. In combination...
url: https://www.elastic.co/docs/reference/ecs/logging/nodejs
products:
  - ECS Logging
  - ECS Logging Node.js
---

# ECS Logging Node.js
Node.js ECS loggers are formatter plugins for your favorite logging libraries. They make it easy to format your logs into ECS-compatible JSON. In combination with [filebeat](https://www.elastic.co/products/beats/filebeat) you can send your logs directly to Elasticsearch and leverage [Kibana’s Logs app](https://www.elastic.co/docs/solutions/observability/logs/explore-logs) to inspect all logs in one single place.
The Node.js ECS logging formatters log structured JSON and support serialization of Error objects and HTTP Request and Response objects from Node.js core and popular web frameworks. A minimal log record includes the following fields:
```json
{
  "@timestamp": "2021-01-13T21:32:38.095Z",
  "log.level": "info",
  "message": "hi",
  "ecs.version": "8.10.0"
}
```

<tip>
  Want to learn more about ECS, ECS logging, and other available language plugins? See the [ECS logging guide](https://www.elastic.co/docs/reference/ecs/logging/intro).
</tip>

Ready to jump into Node.js ECS logging?
- [ECS Logging with Pino](https://www.elastic.co/docs/reference/ecs/logging/nodejs/pino)
- [ECS Logging with Winston](https://www.elastic.co/docs/reference/ecs/logging/nodejs/winston)
- [ECS Logging with Morgan](https://www.elastic.co/docs/reference/ecs/logging/nodejs/morgan)

If you’d like to try out a tutorial using Node.js ECS logging with winston, see [Ingest logs from a Node.js web application using Filebeat](https://www.elastic.co/docs/manage-data/ingest/ingesting-data-from-applications/ingest-logs-from-nodejs-web-application-using-filebeat).