﻿---
title: ECS Logging Go (Logrus)
description: ECS loggers are formatter/encoder plugins for your favorite logging libraries. They make it easy to format your logs into ECS-compatible JSON. The encoder...
url: https://www.elastic.co/docs/reference/ecs/logging/go-logrus
products:
  - ECS Logging
  - ECS Logging Go (Logrus)
---

# ECS Logging Go (Logrus)
ECS loggers are formatter/encoder plugins for your favorite logging libraries. They make it easy to format your logs into ECS-compatible JSON.
The encoder logs in JSON format, relying on the default [logrus.JSONFormatter](https://pkg.go.dev/github.com/sirupsen/logrus#JSONFormatter) internally. It also handles the logging of error fields in [ECS error format](https://www.elastic.co/docs/reference/ecs/ecs-error).
By default, the following fields are added:
```json
{
  "log.level": "info",
  "@timestamp": "2020-09-13T10:48:03.000Z",
  "message":" some logging info",
  "ecs.version": "1.6.0"
}
```

<tip>
  Want to learn more about ECS, ECS logging, and other available language plugins? See the [ECS logging guide](https://www.elastic.co/docs/reference/ecs/logging/intro).
</tip>

Ready to jump into `ecslogrus`? [Get started](https://www.elastic.co/docs/reference/ecs/logging/go-logrus/setup).