﻿---
title: Get started with ECS Logging .NET
description: If you want to integrate with an existing logger emitting ECS json to a file or stdout/stderr. Choose one of our formatters: Elastic.CommonSchema.Serilog,...
url: https://www.elastic.co/docs/reference/ecs/logging/dotnet/setup
products:
  - ECS Logging
  - ECS Logging .NET
---

# Get started with ECS Logging .NET
## Step 1: Configure application logging

If you want to integrate with an existing logger emitting ECS json to a file or stdout/stderr.
Choose one of our formatters:
- [`Elastic.CommonSchema.Serilog`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/serilog-formatter)
- [`Elastic.CommonSchema.NLog`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/nlog-formatter)
- [`Elastic.CommonSchema.Log4Net`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/log4net-formatter)

If you want to write the logs directly to one of Elastic’s endpoints (e.g Elastic Cloud / Elasticsearch)
Choose one of our data shipping loggers:
- [`Elastic.Serilog.Sinks`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/serilog-data-shipper)
- [`Elastic.Extensions.Logging`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/extensions-logging-data-shipper)


## Step 2: Enable APM log correlation (optional)

If you are using the Elastic APM .NET agent, [log correlation can be configured](https://www.elastic.co/docs/reference/apm/agents/dotnet/logs) to inject trace, transaction and span id fields into log events.
By default the ECS logging integrations will read tracing information from [System.Diagnostics.Activity](https://learn.microsoft.com/en-us/dotnet/api/system.diagnostics.activity?view=net-7.0) if the APM logging corrolation libraries are not installed.

## Step 3: Configure Filebeat (optional)

If you are using one of our log formatters you can use the following methods to ship these logs to Elastic.
<tab-set>
  <tab-item title="Log file">
    1. Follow the [Filebeat quick start](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-installation-configuration)
    2. Add the following configuration to your `filebeat.yaml` file.
    For Filebeat 7.16+
    ```yaml
    filebeat.inputs:
    - type: filestream 
      paths: /path/to/logs.json
      parsers:
        - ndjson:
          overwrite_keys: true 
          add_error_key: true 
          expand_keys: true 

    processors: 
      - add_host_metadata: ~
      - add_cloud_metadata: ~
      - add_docker_metadata: ~
      - add_kubernetes_metadata: ~
    ```
    For Filebeat < 7.16
    ```yaml
    filebeat.inputs:
    - type: log
      paths: /path/to/logs.json
      json.keys_under_root: true
      json.overwrite_keys: true
      json.add_error_key: true
      json.expand_keys: true

    processors:
    - add_host_metadata: ~
    - add_cloud_metadata: ~
    - add_docker_metadata: ~
    - add_kubernetes_metadata: ~
    ```
  </tab-item>

  <tab-item title="Kubernetes">
    1. Make sure your application logs to stdout/stderr.
    2. Follow the [Run Filebeat on Kubernetes](https://www.elastic.co/docs/reference/beats/filebeat/running-on-kubernetes) guide.
    3. Enable [hints-based autodiscover](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover-hints) (uncomment the corresponding section in `filebeat-kubernetes.yaml`).
    4. Add these annotations to your pods that log using ECS loggers. This will make sure the logs are parsed appropriately.

    ```yaml
    annotations:
      co.elastic.logs/json.overwrite_keys: true 
      co.elastic.logs/json.add_error_key: true 
      co.elastic.logs/json.expand_keys: true 
    ```
  </tab-item>

  <tab-item title="Docker">
    1. Make sure your application logs to stdout/stderr.
    2. Follow the [Run Filebeat on Docker](https://www.elastic.co/docs/reference/beats/filebeat/running-on-docker) guide.
    3. Enable [hints-based autodiscover](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover-hints).
    4. Add these labels to your containers that log using ECS loggers. This will make sure the logs are parsed appropriately.

    ```yaml
    labels:
      co.elastic.logs/json.overwrite_keys: true 
      co.elastic.logs/json.add_error_key: true 
      co.elastic.logs/json.expand_keys: true 
    ```
  </tab-item>
</tab-set>

For more information, see the [Filebeat reference](https://www.elastic.co/docs/reference/beats/filebeat/configuring-howto-filebeat).