﻿---
title: ECS Logging .NET
description: ECS logging are integrations for your favorite .NET logging libraries. They make it easy to format your logs into ECS-compatible JSON. The .NET ECS libraries...
url: https://www.elastic.co/docs/reference/ecs/logging/dotnet
products:
  - ECS Logging
  - ECS Logging .NET
---

# ECS Logging .NET
ECS logging are integrations for your favorite .NET logging libraries. They make it easy to format your logs into ECS-compatible JSON.
<tip>
  Want to learn more about ECS, ECS logging, and other available language plugins? See the [ECS logging overview](https://www.elastic.co/docs/reference/ecs/logging/intro).
</tip>

The .NET ECS libraries fall into several categories:

## Model

At its core all .NET ECS libraries are powered by `Elastic.CommonSchema` which strongly types the ECS specification to .NET classes.
This library can be used to map your events to ECS in a typesafe fashion.
```csharp
var doc = EcsDocument.CreateNewWithDefaults<EcsDocument>();
doc = new EcsDocument();
```

[Lean more about Elastic.CommonSchema](https://www.elastic.co/docs/reference/ecs/logging/dotnet/ecs-dotnet).

## Log formatters

Our log formatters allow you to change the way various logging frameworks log to IO (file/console) to use ECS json.
- [`Elastic.CommonSchema.Serilog`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/serilog-formatter)
- [`Elastic.CommonSchema.NLog`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/nlog-formatter)
- [`Elastic.CommonSchema.Log4Net`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/log4net-formatter)


## Data shippers

Our datashippers integrate with logging frameworks to facilitate sending events (logs) to various off Elastic receivers.
Currently these shippers support Elastic Cloud & Elasticsearch but other outputs are in the works.
- [`Elastic.Serilog.Sinks`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/serilog-data-shipper)
- [`Elastic.Extensions.Logging`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/extensions-logging-data-shipper)
- [`Elastic.CommonSchema.BenchmarkDotNetExporter`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/benchmark-dotnet-data-shipper)

All the data shippers utilize [`Elastic.Ingest.Elasticsearch.CommonSchema`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/ecs-ingest-channels) to send events to Elasticsearch.

## Enrichers

Enrichers can be installed next to `Log Formatters` and `Data Shippers` to automatically enrich the ECS json that gets produced.
- [`Elastic.Apm.SerilogEnricher`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/apm-serilog-enricher)
- [`Elastic.Apm.NLog`](https://www.elastic.co/docs/reference/ecs/logging/dotnet/apm-nlog-enricher)


## Architecture

The libraries reuse the same components that power other .NET libraries from Elastic—ensuring a common way to both configure and monitor Elastic’s .NET libraries.
![ECS.NET Artichtecture overview](https://www.elastic.co/docs/reference/ecs/logging/dotnet/images/ecs-dotnet-overview.png)
At its core all data shippers depend on [Elastic.Transport](https://github.com/elastic/elastic-transport-net) to coordinate HttpRequests. This library is also the heart of Elastic’s clients and ensures we share best practices and configuration options.
The data shipper libraries all depend upon the push based ingestion abstractions from [Elastic.Ingest.*](https://github.com/elastic/elastic-ingest-dotnet) that presents an easy to use `System.Threading.Channels` backed method to push events as batches at variable rates to external datasources.
[Lean more about Elastic.Ingest.Elasticsearch.CommonSchema](https://www.elastic.co/docs/reference/ecs/logging/dotnet/ecs-ingest-channels).