﻿---
title: x509 Certificate fields
description: This implements the common core fields for x509 certificates. This information is likely logged with TLS sessions, digital signatures found in executable...
url: https://www.elastic.co/docs/reference/ecs/ecs-x509
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# x509 Certificate fields
This implements the common core fields for x509 certificates. This information is likely logged with TLS sessions, digital signatures found in executable binaries, S/MIME information in email bodies, or analysis of files on disk.
When the certificate relates to a file, use the fields at `file.x509`. When hashes of the DER-encoded certificate are available, the `hash` data set should be populated as well (e.g. `file.hash.sha256`).
Events that contain certificate information about network connections, should use the x509 fields under the relevant TLS fields: `tls.server.x509` and/or `tls.client.x509`.

## x509 Certificate field details


| Field                                                                       | Description                                                                                                                                                                                                                                                                                               | Level    |
|-----------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [x509.alternative_names](#field-x509-alternative-names)                     | List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.type: keywordNote: This field should contain an array of values.example: `*.elastic.co`                          | extended |
| [x509.issuer.common_name](#field-x509-issuer-common-name)                   | List of common name (CN) of issuing certificate authority.type: keywordNote: This field should contain an array of values.example: `Example SHA2 High Assurance Server CA`                                                                                                                                | extended |
| [x509.issuer.country](#field-x509-issuer-country)                           | List of country (C) codestype: keywordNote: This field should contain an array of values.example: `US`                                                                                                                                                                                                    | extended |
| [x509.issuer.distinguished_name](#field-x509-issuer-distinguished-name)     | Distinguished name (DN) of issuing certificate authority.type: keywordexample: `C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA`                                                                                                                                        | extended |
| [x509.issuer.locality](#field-x509-issuer-locality)                         | List of locality names (L)type: keywordNote: This field should contain an array of values.example: `Mountain View`                                                                                                                                                                                        | extended |
| [x509.issuer.organization](#field-x509-issuer-organization)                 | List of organizations (O) of issuing certificate authority.type: keywordNote: This field should contain an array of values.example: `Example Inc`                                                                                                                                                         | extended |
| [x509.issuer.organizational_unit](#field-x509-issuer-organizational-unit)   | List of organizational units (OU) of issuing certificate authority.type: keywordNote: This field should contain an array of values.example: `www.example.com`                                                                                                                                             | extended |
| [x509.issuer.state_or_province](#field-x509-issuer-state-or-province)       | List of state or province names (ST, S, or P)type: keywordNote: This field should contain an array of values.example: `California`                                                                                                                                                                        | extended |
| [x509.not_after](#field-x509-not-after)                                     | Time at which the certificate is no longer considered valid.type: dateexample: `2020-07-16T03:15:39Z`                                                                                                                                                                                                     | extended |
| [x509.not_before](#field-x509-not-before)                                   | Time at which the certificate is first considered valid.type: dateexample: `2019-08-16T01:40:25Z`                                                                                                                                                                                                         | extended |
| [x509.public_key_algorithm](#field-x509-public-key-algorithm)               | Algorithm used to generate the public key.type: keywordexample: `RSA`                                                                                                                                                                                                                                     | extended |
| [x509.public_key_curve](#field-x509-public-key-curve)                       | The curve used by the elliptic curve public key algorithm. This is algorithm specific.type: keywordexample: `nistp521`                                                                                                                                                                                    | extended |
| [x509.public_key_exponent](#field-x509-public-key-exponent)                 | Exponent used to derive the public key. This is algorithm specific.type: longexample: `65537`                                                                                                                                                                                                             | extended |
| [x509.public_key_size](#field-x509-public-key-size)                         | The size of the public key space in bits.type: longexample: `2048`                                                                                                                                                                                                                                        | extended |
| [x509.serial_number](#field-x509-serial-number)                             | Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.type: keywordexample: `55FBB9C7DEBF09809D12CCAA`                                                                                         | extended |
| [x509.signature_algorithm](#field-x509-signature-algorithm)                 | Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See [https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353](https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).type: keywordexample: `SHA256-RSA` | extended |
| [x509.subject.common_name](#field-x509-subject-common-name)                 | List of common names (CN) of subject.type: keywordNote: This field should contain an array of values.example: `shared.global.example.net`                                                                                                                                                                 | extended |
| [x509.subject.country](#field-x509-subject-country)                         | List of country (C) codetype: keywordNote: This field should contain an array of values.example: `US`                                                                                                                                                                                                     | extended |
| [x509.subject.distinguished_name](#field-x509-subject-distinguished-name)   | Distinguished name (DN) of the certificate subject entity.type: keywordexample: `C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net`                                                                                                                                     | extended |
| [x509.subject.locality](#field-x509-subject-locality)                       | List of locality names (L)type: keywordNote: This field should contain an array of values.example: `San Francisco`                                                                                                                                                                                        | extended |
| [x509.subject.organization](#field-x509-subject-organization)               | List of organizations (O) of subject.type: keywordNote: This field should contain an array of values.example: `Example, Inc.`                                                                                                                                                                             | extended |
| [x509.subject.organizational_unit](#field-x509-subject-organizational-unit) | List of organizational units (OU) of subject.type: keywordNote: This field should contain an array of values.                                                                                                                                                                                             | extended |
| [x509.subject.state_or_province](#field-x509-subject-state-or-province)     | List of state or province names (ST, S, or P)type: keywordNote: This field should contain an array of values.example: `California`                                                                                                                                                                        | extended |
| [x509.version_number](#field-x509-version-number)                           | Version of x509 format.type: keywordexample: `3`                                                                                                                                                                                                                                                          | extended |


## Field reuse

The `x509` fields are expected to be nested at:
- `file.x509`
- `threat.enrichments.indicator.x509`
- `threat.indicator.x509`
- `tls.client.x509`
- `tls.server.x509`

Note also that the `x509` fields are not expected to be used directly at the root of the events.