﻿---
title: Vulnerability fields
description: The vulnerability fields describe information about a vulnerability that is relevant to an event. 
url: https://www.elastic.co/docs/reference/ecs/ecs-vulnerability
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Vulnerability fields
The vulnerability fields describe information about a vulnerability that is relevant to an event.

## Vulnerability field details


| Field                                                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Level    |
|-------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [vulnerability.category](#field-vulnerability-category)                       | The type of system or architecture that the vulnerability affects. These may be platform-specific (for example, Debian or SUSE) or general (for example, Database or Firewall). For example ([https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm](https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm))This field must be an array.type: keywordNote: This field should contain an array of values.example: `["Firewall"]`                                                 | extended |
| [vulnerability.classification](#field-vulnerability-classification)           | The classification of the vulnerability scoring system. For example ([https://www.first.org/cvss/](https://www.first.org/cvss/))type: keywordexample: `CVSS`                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [vulnerability.description](#field-vulnerability-description)                 | The description of the vulnerability that provides additional context of the vulnerability. For example ([https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created](https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created))type: keywordMulti-fields:* vulnerability.description.text (type: match_only_text)example: `In macOS before 2.12.6, there is a vulnerability in the RPC...`                                                                                                                                             | extended |
| [vulnerability.enumeration](#field-vulnerability-enumeration)                 | The type of identifier used for this vulnerability. For example ([https://cve.mitre.org/about/](https://cve.mitre.org/about/))type: keywordexample: `CVE`                                                                                                                                                                                                                                                                                                                                                                                                     | extended |
| [vulnerability.id](#field-vulnerability-id)                                   | The identification (ID) is the number portion of a vulnerability entry. It includes a unique identification number for the vulnerability. For example ([https://cve.mitre.org/about/faqs.html#what_is_cve_id](https://cve.mitre.org/about/faqs.html#what_is_cve_id))type: keywordexample: `CVE-2019-00001`                                                                                                                                                                                                                                                    | extended |
| [vulnerability.reference](#field-vulnerability-reference)                     | A resource that provides additional information, context, and mitigations for the identified vulnerability.type: keywordexample: `https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-6111`                                                                                                                                                                                                                                                                                                                                                               | extended |
| [vulnerability.report_id](#field-vulnerability-report-id)                     | The report or scan identification number.type: keywordexample: `20191018.0001`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | extended |
| [vulnerability.scanner.vendor](#field-vulnerability-scanner-vendor)           | The name of the vulnerability scanner vendor.type: keywordexample: `Tenable`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | extended |
| [vulnerability.score.base](#field-vulnerability-score-base)                   | Scores can range from 0.0 to 10.0, with 10.0 being the most severe.Base scores cover an assessment for exploitability metrics (attack vector, complexity, privileges, and user interaction), impact metrics (confidentiality, integrity, and availability), and scope. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))type: floatexample: `5.5`                                                                                                                                          | extended |
| [vulnerability.score.environmental](#field-vulnerability-score-environmental) | Scores can range from 0.0 to 10.0, with 10.0 being the most severe.Environmental scores cover an assessment for any modified Base metrics, confidentiality, integrity, and availability requirements. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))type: floatexample: `5.5`                                                                                                                                                                                                           | extended |
| [vulnerability.score.temporal](#field-vulnerability-score-temporal)           | Scores can range from 0.0 to 10.0, with 10.0 being the most severe.Temporal scores cover an assessment for code maturity, remediation level, and confidence. For example ([https://www.first.org/cvss/specification-document](https://www.first.org/cvss/specification-document))type: float                                                                                                                                                                                                                                                                  | extended |
| [vulnerability.score.version](#field-vulnerability-score-version)             | The National Vulnerability Database (NVD) provides qualitative severity rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges in addition to the severity ratings for CVSS v3.0 as they are defined in the CVSS v3.0 specification.CVSS is owned and managed by FIRST.Org, Inc. (FIRST), a US-based non-profit organization, whose mission is to help computer security incident response teams across the world. For example ([https://nvd.nist.gov/vuln-metrics/cvss](https://nvd.nist.gov/vuln-metrics/cvss))type: keywordexample: `2.0` | extended |
| [vulnerability.severity](#field-vulnerability-severity)                       | The severity of the vulnerability can help with metrics and internal prioritization regarding remediation. For example ([https://nvd.nist.gov/vuln-metrics/cvss](https://nvd.nist.gov/vuln-metrics/cvss))type: keywordexample: `Critical`                                                                                                                                                                                                                                                                                                                     | extended |