﻿---
title: Volume fields
description: Fields related to storage volume details. 
url: https://www.elastic.co/docs/reference/ecs/ecs-volume
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Volume fields
Fields related to storage volume details.

## Volume field details


| Field                                                     | Description                                                                                                                                                            | Level    |
|-----------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [volume.bus_type](#field-volume-bus-type)                 | Bus type of the device, such as `Nvme`, `Usb`, or `FileBackedVirtual`.type: keywordexample: `FileBackedVirtual`                                                        | extended |
| [volume.default_access](#field-volume-default-access)     | Describes the default access(es) of the volume.type: keyword                                                                                                           | extended |
| [volume.device_name](#field-volume-device-name)           | Full path of the volume device.Only populate this field for POSIX system volumes.type: keyword                                                                         | extended |
| [volume.device_type](#field-volume-device-type)           | Volume device type.The most frequently seen volume device types are `Disk File System` and `CD-ROM File System`.type: keywordexample: `CD-ROM File System`             | extended |
| [volume.dos_name](#field-volume-dos-name)                 | The MS-DOS name of a device.DOS device name is in the format of driver letters, such as `C:`. The field is relevant to Windows systems only.type: keywordexample: `E:` | extended |
| [volume.file_system_type](#field-volume-file-system-type) | Volume device file system type.The most common volume file system types are `NTFS` and `UDF`.type: keyword                                                             | extended |
| [volume.mount_name](#field-volume-mount-name)             | Mount name of the volume device.Only populate this field for POSIX system volumes.type: keyword                                                                        | extended |
| [volume.nt_name](#field-volume-nt-name)                   | The NT device name.NT device name uses a format of `\Device\HarddiskVolume2`. The field is relevant to Windows systems only.type: keywordexample: `\Device\Cdrom1`     | extended |
| [volume.product_id](#field-volume-product-id)             | ProductID of the device.The vendor provides the ProductID for the volume, if any.type: keyword                                                                         | extended |
| [volume.product_name](#field-volume-product-name)         | Product name of the volume.The volume device vendor provides this value.type: keywordexample: `Virtual DVD-ROM`                                                        | extended |
| [volume.removable](#field-volume-removable)               | Indicates if the volume is removable.type: boolean                                                                                                                     | extended |
| [volume.serial_number](#field-volume-serial-number)       | Serial number identifier for the volume device.The serial number is provided by the vendor of the device, if any.type: keyword                                         | extended |
| [volume.size](#field-volume-size)                         | Size of the volume device in bytes.type: long                                                                                                                          | extended |
| [volume.vendor_id](#field-volume-vendor-id)               | VendorID of the volume device.The volume device vendor provides this value.type: keyword                                                                               | extended |
| [volume.vendor_name](#field-volume-vendor-name)           | Vendor name of the volume device.The value is provided by the vendor of the device.type: keywordexample: `Msft`                                                        | extended |
| [volume.writable](#field-volume-writable)                 | Indicates if the volume is writable.type: boolean                                                                                                                      | extended |