﻿---
title: VLAN fields
description: The VLAN fields are used to identify 802.1q tag(s) of a packet, as well as ingress and egress VLAN associations of an observer in relation to a specific...
url: https://www.elastic.co/docs/reference/ecs/ecs-vlan
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# VLAN fields
The VLAN fields are used to identify 802.1q tag(s) of a packet, as well as ingress and egress VLAN associations of an observer in relation to a specific packet or connection.
Network.vlan fields are used to record a single VLAN tag, or the outer tag in the case of q-in-q encapsulations, for a packet or connection as observed, typically provided by a network sensor (e.g. Zeek, Wireshark) passively reporting on traffic.
Network.inner VLAN fields are used to report inner q-in-q 802.1q tags (multiple 802.1q encapsulations) as observed, typically provided by a network sensor  (e.g. Zeek, Wireshark) passively reporting on traffic. Network.inner VLAN fields should only be used in addition to network.vlan fields to indicate q-in-q tagging.
Observer.ingress and observer.egress VLAN values are used to record observer specific information when observer events contain discrete ingress and egress VLAN information, typically provided by firewalls, routers, or load balancers.

## VLAN field details


| Field                         | Description                                                                    | Level    |
|-------------------------------|--------------------------------------------------------------------------------|----------|
| [vlan.id](#field-vlan-id)     | VLAN ID as reported by the observer.type: keywordexample: `10`                 | extended |
| [vlan.name](#field-vlan-name) | Optional VLAN name as reported by the observer.type: keywordexample: `outside` | extended |


## Field reuse

The `vlan` fields are expected to be nested at:
- `network.inner.vlan`
- `network.vlan`
- `observer.egress.vlan`
- `observer.ingress.vlan`

Note also that the `vlan` fields are not expected to be used directly at the root of the events.