﻿---
title: Using the categorization fields
description: The event categorization fields work together to identify and group similar events from multiple data sources. These general principles can help guide...
url: https://www.elastic.co/docs/reference/ecs/ecs-using-categorization-fields
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Using the categorization fields
The event categorization fields work together to identify and group similar events from multiple data sources.
These general principles can help guide the categorization process:
- Events from multiple data sources that are similar enough to be viewed or analyzed together, should fall into the same `event.category` field.
- Both `event.category` and `event.type` are arrays and may be populated with multiple allowed values, if the event can be reasonably classified into more than one category and/or type.
- `event.kind`, `event.category`, `event.type` and `event.outcome` all have allowed values. This is to normalize these fields. Values that aren’t in the list of allowed values should not be used.
- Values of `event.outcome` are a very limited set to indicate success or failure. Domain-specific actions, such as deny and allow, that could be considered outcomes are not captured in the `event.outcome` field, but rather in the `event.type` and/or `event.action` fields.
- Values of `event.category`, `event.type`, and `event.outcome` are consistent across all values of `event.kind`.
- When a specific event doesn’t fit into any of the defined allowed categorization values, the field should be left empty.

The following examples detail populating the categorization fields and provides some context for the classification decisions.

### Firewall blocking a network connection

This event from a firewall describes a successfully blocked network connection:
```json
...
  {
    "source": {
      "address": "10.42.42.42",
      "ip": "10.42.42.42",
      "port": 38842
    },
    "destination": {
      "address": "10.42.42.1",
      "ip": "10.42.42.1",
      "port": 443
    },
    "rule": {
      "name": "wan-lan",
      "id": "default"
    },
    ...
    "event": {
      "kind": "event", 
      "category": [ 
        "network"
      ],
      "type": [ 
        "connection",
        "denied"
      ],
      "outcome": "success", 
      "action": "dropped" 
    }
  }
...
```

A "denied" network connection could fall under different action values: "blocked", "dropped", "quarantined", etc. The `event.action` field captures the action taken as described by the source, and populating `event.type:denied` provides an independent, normalized value.
A single query will return all denied network connections which have been normalized with the same categorization values:
```sh
event.category:network AND event.type:denied
```


### Failed attempt to create a user account

User `alice` attempts to add a user account, `bob`, into a directory service, but the action fails:
```json
{
  "user": {
    "name": "alice",
    "target": {
      "name": "bob"
    }
  },
  "event": {
    "kind": "event", 
    "category": [ 
      "iam"
    ],
    "type": [ 
      "user",
      "creation"
    ],
    "outcome": "failure" 
  }
}
```


### Informational listing of a file

A utility, such as a file integrity monitoring (FIM) application, takes inventory of a file but does not access or modify the file:
```json
{
  "file": {
    "name": "example.png",
    "owner": "alice",
    "path": "/home/alice/example.png",
    "type": "file"
  },
  "event": {
    "kind": "event", 
    "category": [ 
      "file"
    ],
    "type": [ 
      "info"
    ]
  }
}
```

The source data didn’t include any context around the event’s outcome, so `event.outcome` should not be populated.

## Security application failed to block a network connection

An intrusion detection system (IDS) attempts to block a connection but fails. The event emitted by the IDS is considered an alert:
```json
{
  "source": {
      "address": "10.42.42.42",
      "ip": "10.42.42.42",
      "port": 38842
    },
  "destination": {
      "address": "10.42.42.1",
      "ip": "10.42.42.1",
      "port": 443
  },
  ...
  "event": {
    "kind": "alert", 
    "category": [ 
      "intrusion_detection",
      "network"
    ],
    "type": [ 
      "connection",
      "denied"
    ],
    "outcome": "failure" 
  }
}
```