﻿---
title: User agent fields
description: The user_agent fields normally come from a browser request. They often show up in web service logs coming from the parsed user agent string. 
url: https://www.elastic.co/docs/reference/ecs/ecs-user_agent
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# User agent fields
The user_agent fields normally come from a browser request.
They often show up in web service logs coming from the parsed user agent string.

## User agent field details


| Field                                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Level    |
|---------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [user_agent.device.name](#field-user-agent-device-name) | Name of the device.type: keywordexample: `iPhone`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | extended |
| [user_agent.name](#field-user-agent-name)               | Name of the user agent.type: keywordexample: `Safari`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user_agent.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-name)                                                                                                                                                                                                             | extended |
| [user_agent.original](#field-user-agent-original)       | Unparsed user_agent string.type: keywordMulti-fields:* user_agent.original.text (type: match_only_text)example: `Mozilla/5.0 (iPhone; CPU iPhone OS 12_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user_agent.original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-original) | extended |
| [user_agent.version](#field-user-agent-version)         | Version of the user agent.type: keywordexample: `12.0`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user_agent.version](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user-agent/#user-agent-version)                                                                                                                                                                                                      | extended |


### Field sets that can be nested under User agent


| Location          | Field Set                                              | Description                                               |
|-------------------|--------------------------------------------------------|-----------------------------------------------------------|
| `user_agent.os.*` | [os](https://www.elastic.co/docs/reference/ecs/ecs-os) | OS fields contain information about the operating system. |