﻿---
title: User fields
description: The user fields describe information about the user that is relevant to the event. Fields can have one entry or multiple entries. If a user has more than...
url: https://www.elastic.co/docs/reference/ecs/ecs-user
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# User fields
The user fields describe information about the user that is relevant to the event.
Fields can have one entry or multiple entries. If a user has more than one id, provide an array that includes all of them.

## User field details


| Field                                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Level    |
|-----------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [user.domain](#field-user-domain)       | Name of the directory the user is a member of.For example, an LDAP or Active Directory domain name.type: keyword                                                                                                                                                                                                                                                                                                                                                                                           | extended |
| [user.email](#field-user-email)         | User email address.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.email](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-email)                                                                                                                                           | extended |
| [user.full_name](#field-user-full-name) | User's full name, if available.type: keywordMulti-fields:* user.full_name.text (type: match_only_text)example: `Albert Einstein`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.full_name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-full-name)                                   | extended |
| [user.hash](#field-user-hash)           | Unique user hash to correlate information for a user in anonymized form.Useful if `user.id` or `user.name` contain confidential information and cannot be used.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.hash](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-hash) | extended |
| [user.id](#field-user-id)               | Unique identifier of the user.type: keywordexample: `S-1-5-21-202424912787-2692429404-2351956786-1000`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.id](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-id)                                                                           | core     |
| [user.name](#field-user-name)           | Short name or login of the user.type: keywordMulti-fields:* user.name.text (type: match_only_text)example: `a.einstein`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.name](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-name)                                                      | core     |
| [user.roles](#field-user-roles)         | Array of user roles at the time of the event.type: keywordNote: This field should contain an array of values.example: `["kibana_admin", "reporting_user"]`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [user.roles](https://opentelemetry.io/docs/specs/semconv/attributes-registry/user/#user-roles)                 | extended |


## Field reuse

The `user` fields are expected to be nested at:
- `client.user`
- `destination.user`
- `process.attested_user`
- `process.real_user`
- `process.saved_user`
- `process.user`
- `server.user`
- `source.user`
- `user.changes`
- `user.effective`
- `user.target`

Note also that the `user` fields may be used directly at the root of the events.

### Field sets that can be nested under User


| Location           | Field Set                                                      | Description                                                          |
|--------------------|----------------------------------------------------------------|----------------------------------------------------------------------|
| `user.changes.*`   | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)     | Captures changes made to a user.                                     |
| `user.effective.*` | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)     | User whose privileges were assumed.                                  |
| `user.entity.*`    | [entity](https://www.elastic.co/docs/reference/ecs/ecs-entity) | Fields to describe various types of entities across IT environments. |
| `user.group.*`     | [group](https://www.elastic.co/docs/reference/ecs/ecs-group)   | User's group relevant to the event.                                  |
| `user.risk.*`      | [risk](https://www.elastic.co/docs/reference/ecs/ecs-risk)     | Fields for describing risk score and level.                          |
| `user.target.*`    | [user](https://www.elastic.co/docs/reference/ecs/ecs-user)     | Targeted user of action taken.                                       |


### User field usage

For usage and examples of the user fields, please see the [User fields usage and examples](https://www.elastic.co/docs/reference/ecs/ecs-user-usage) section.