﻿---
title: URL fields
description: URL fields provide support for complete or partial URLs, and supports the breaking down into scheme, domain, path, and so on. The url fields are expected...
url: https://www.elastic.co/docs/reference/ecs/ecs-url
products:
  - Elastic Common Schema (ECS)
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# URL fields
URL fields provide support for complete or partial URLs, and supports the breaking down into scheme, domain, path, and so on.

## URL field details


| Field                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Level    |
|-------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [url.domain](#field-url-domain)                       | Domain of the url, such as "www.elastic.co".In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field.If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.type: keywordexample: `www.elastic.co`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-domain)                                                                                                                                                                                     | extended |
| [url.extension](#field-url-extension)                 | The field contains the file extension from the original request url, excluding the leading dot.The file extension is only set if it exists, as not every url has a file extension.The leading period must not be included. For example, the value must be "png", not ".png".Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").type: keywordexample: `png`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.extension](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-extension)                                                                                                                                      | extended |
| [url.fragment](#field-url-fragment)                   | Portion of the url after the `#`, such as "top".The `#` is not part of the fragment.type: keyword![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.fragment](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-fragment)                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [url.full](#field-url-full)                           | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.type: wildcardMulti-fields:* url.full.text (type: match_only_text)example: `https://www.elastic.co:443/search?q=elasticsearch#top`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.full](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-full)                                                                                                                                                                                                                                                                                                 | extended |
| [url.original](#field-url-original)                   | Unmodified original url as seen in the event source.Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path.This field is meant to represent the URL as it was observed, complete or not.type: wildcardMulti-fields:* url.original.text (type: match_only_text)example: `https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.original](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-original)                                                                                                                                     | extended |
| [url.password](#field-url-password)                   | Password of the request.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |
| [url.path](#field-url-path)                           | Path of the request, such as "/search".type: wildcard![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.path](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-path)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | extended |
| [url.port](#field-url-port)                           | Port of the request, such as 443.type: longexample: `443`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.port](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-port)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | extended |
| [url.query](#field-url-query)                         | The field contains the entire query string, excluding the leading `?` character, such as "q=elasticsearch".If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.type: keywordexample: `q=elasticsearch&sort=desc`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.query](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-query)                                                                                                                                                                                                                    | extended |
| [url.registered_domain](#field-url-registered-domain) | The highest registered url domain, stripped of the subdomain.For example, the registered domain for "foo.example.com" is "example.com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".type: keywordexample: `example.com`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.registered_domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-registered-domain)                                                                                                                                 | extended |
| [url.scheme](#field-url-scheme)                       | Scheme of the request, such as "https".Note: The `:` is not part of the scheme.type: keywordexample: `https`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.scheme](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-scheme)                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | extended |
| [url.subdomain](#field-url-subdomain)                 | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.For example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.type: keywordexample: `east`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.subdomain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-subdomain) | extended |
| [url.top_level_domain](#field-url-top-level-domain)   | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".This value can be determined precisely with a list like the public suffix list ([https://publicsuffix.org](https://publicsuffix.org)). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".type: keywordexample: `co.uk`![OTel Badge](https://img.shields.io/badge/OpenTelemetry-4a5ca6?style=flat&logo=opentelemetry) [![match](https://img.shields.io/badge/match-93c93e?style=flat)](/docs/reference/ecs/ecs-opentelemetry#ecs-opentelemetry-relation) [url.top_level_domain](https://opentelemetry.io/docs/specs/semconv/attributes-registry/url/#url-top-level-domain)                                                                                                   | extended |
| [url.username](#field-url-username)                   | Username of the request.type: keyword                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | extended |


## Field reuse

The `url` fields are expected to be nested at:
- `threat.enrichments.indicator.url`
- `threat.indicator.url`

Note also that the `url` fields may be used directly at the root of the events.